% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/charts.DE.R, R/charts.GenSA.R, R/charts.PSO.R,
%   R/charts.ROI.R, R/charts.RP.R
\name{plot.optimize.portfolio.DEoptim}
\alias{plot.optimize.portfolio.DEoptim}
\alias{plot.optimize.portfolio.GenSA}
\alias{plot.optimize.portfolio.pso}
\alias{plot.optimize.portfolio.ROI}
\alias{plot.optimize.portfolio.random}
\alias{plot.optimize.portfolio}
\title{plot method for objects of class \code{optimize.portfolio}}
\usage{
\method{plot}{optimize.portfolio.DEoptim}(
  x,
  ...,
  return.col = "mean",
  risk.col = "ES",
  chart.assets = FALSE,
  neighbors = NULL,
  main = "optimized portfolio plot",
  xlim = NULL,
  ylim = NULL
)

\method{plot}{optimize.portfolio.GenSA}(
  x,
  ...,
  rp = FALSE,
  return.col = "mean",
  risk.col = "ES",
  chart.assets = FALSE,
  cex.axis = 0.8,
  element.color = "darkgray",
  neighbors = NULL,
  main = "GenSA.Portfolios",
  xlim = NULL,
  ylim = NULL
)

\method{plot}{optimize.portfolio.pso}(
  x,
  ...,
  return.col = "mean",
  risk.col = "ES",
  chart.assets = FALSE,
  cex.axis = 0.8,
  element.color = "darkgray",
  neighbors = NULL,
  main = "PSO.Portfolios",
  xlim = NULL,
  ylim = NULL
)

\method{plot}{optimize.portfolio.ROI}(
  x,
  ...,
  rp = FALSE,
  risk.col = "ES",
  return.col = "mean",
  chart.assets = FALSE,
  element.color = "darkgray",
  neighbors = NULL,
  main = "ROI.Portfolios",
  xlim = NULL,
  ylim = NULL
)

\method{plot}{optimize.portfolio.random}(
  x,
  ...,
  return.col = "mean",
  risk.col = "ES",
  chart.assets = FALSE,
  neighbors = NULL,
  xlim = NULL,
  ylim = NULL,
  main = "optimized portfolio plot"
)

\method{plot}{optimize.portfolio}(
  x,
  ...,
  return.col = "mean",
  risk.col = "ES",
  chart.assets = FALSE,
  neighbors = NULL,
  xlim = NULL,
  ylim = NULL,
  main = "optimized portfolio plot"
)
}
\arguments{
\item{x}{set of portfolios created by \code{\link{optimize.portfolio}}}

\item{\dots}{any other passthru parameters}

\item{return.col}{string name of column to use for returns (vertical axis)}

\item{risk.col}{string name of column to use for risk (horizontal axis)}

\item{chart.assets}{TRUE/FALSE to include risk-return scatter of assets}

\item{neighbors}{set of 'neighbor portfolios to overplot}

\item{main}{an overall title for the plot: see \code{\link{title}}}

\item{xlim}{set the limit on coordinates for the x-axis}

\item{ylim}{set the limit on coordinates for the y-axis}

\item{rp}{TRUE/FALSE to plot feasible portfolios generated by \code{\link{random_portfolios}}}

\item{cex.axis}{the magnification to be used for axis annotation relative to the current setting of \code{cex}.}

\item{element.color}{provides the color for drawing less-important chart elements, such as the box lines, axis lines, etc.}
}
\description{
Scatter and weights chart for portfolio optimizations run with trace=TRUE
}
\details{
\code{return.col} must be the name of a function used to compute the return metric on the random portfolio weights
\code{risk.col} must be the name of a function used to compute the risk metric on the random portfolio weights

\code{neighbors} may be specified in three ways.  
The first is as a single number of neighbors.  This will extract the \code{neighbors} closest 
portfolios in terms of the \code{out} numerical statistic.
The second method consists of a numeric vector for \code{neighbors}.
This will extract the \code{neighbors} with portfolio index numbers that correspond to the vector contents.
The third method for specifying \code{neighbors} is to pass in a matrix.  
This matrix should look like the output of \code{\link{extractStats}}, and should contain
\code{risk.col},\code{return.col}, and weights columns all properly named.

The ROI and GenSA solvers do not store the portfolio weights like DEoptim or random
portfolios, random portfolios can be generated for the scatter plot with the
\code{rp} argument.
}
