% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lagfit.R
\name{lagfit}
\alias{lagfit}
\title{Fits a piecewise glm model with lags}
\usage{
lagfit(
  data,
  yeardata,
  species = NULL,
  knots = NULL,
  zeros = TRUE,
  plotlag = FALSE,
  plotfreq = FALSE
)
}
\arguments{
\item{data}{a dataframe containing the columns Species (optional), Year, Frequency and Specimens.}

\item{yeardata}{a dataframe containing the columns Year and Specimens giving the total number of Specimens for each Year.}

\item{species}{list of species for which the model is to be fitted. Default is NULL, which fits the model for all species in the data.}

\item{knots}{a list of knots to be used for the piecewise model. Default is NULL, which chooses the optimal model with 0-4 knots.}

\item{zeros}{logical. Specifies whether missing year for the species will be filled with zeros. Default is TRUE.}

\item{plotlag}{logical. If TRUE a plot of the fitted model will be produced for each species.}

\item{plotfreq}{logical. If TRUE frquency plots will be created for each species.}
}
\value{
If the model is fit for a single species following are returned as a list
\itemize{
\item Species - Species name
\item Scene - Different scenario of the fit between the knots. A sequence of 0, + or - is returned. A 0 indicates constant, + indicates increasing and a - indicates decreasing.
\item Lag - Logical. Is there a lag present or not.
\item Laglength - Length of the first lag. Position of the First Knot - the first year for that species
\item FirstYear - The first year for that species for which data is available.
\item EndYear - The first knot position.
\item fit - the fitted model.
}

If the number of species is more than one, then a list is returned with following items:
\itemize{
\item  fitdata - dataframe is returned with the items in the above list except for the fitted model.
\item  fitcoefs - list of coefficients for the piecewise fits for each Species
}
}
\description{
This function fits a piecewise poisson model to the frequency data of different Species. It assumes that the data
contains columns Year, Frequency and Specimens.
}
\examples{
#Run lagfit for 1 species only
Species = unique(fdata$Species) #List of all species

fit1 = lagfit(fdata, yeardata, species=Species[1])
#Run lagfit for multiple species
fit2 = lagfit(fdata, yeardata, species=Species[1:3])
fitdata = fit2$fitdata  #Dataframe containing fits
fitcoefs = fit2$fitcoefs #List containing slopes of the fitted splines

\dontrun{
#Run lagfit for the whole dataset
fitall = lagfit(fdata, yeardata)
}
}
