% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{growthplot}
\alias{growthplot}
\title{Produces plot of the fitted spline function after adjusting for number of Specimens}
\usage{
growthplot(
  fit,
  ylim = NULL,
  xlab = "Year",
  ylab = "Adjusted Frequency",
  main = fit$name,
  ...
)
}
\arguments{
\item{fit}{a "lagphase" fit object to plot}

\item{ylim}{vector of size 2 - limits of the $y$-axis}

\item{xlab}{Label for the $x$-axis}

\item{ylab}{Label for the $y$-axis}

\item{main}{Title of the plot}

\item{...}{(optional) parameters to pass to plot}
}
\value{
Produces a plot of the fit with confidence bands
}
\description{
Produces plot of the fitted spline function after adjusting for number of Specimens
}
\examples{
Species = unique(fdata$Species) #List of all species
fit1 = lagfit(fdata, yeardata, species=Species[1])
growthplot(fit1$fit)
}
