% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCA.R
\name{PCA}
\alias{PCA}
\title{A function to perform principal component analysis (PCA) on genetic data. Loci with missing data will be removed prior to PCA.}
\usage{
PCA(
  data,
  center = TRUE,
  scale = FALSE,
  missing_value = NA,
  write = FALSE,
  prefix = NULL
)
}
\arguments{
\item{data}{Character. String indicating the name of the vcf file, geno file or vcfR object to be used in the analysis.}

\item{center}{Boolean. Whether or not to center the data before principal component analysis.}

\item{scale}{Boolean. Whether or not to scale the data before principal component analysis.}

\item{missing_value}{Character. String indicating missing data in the input data. It is assumed to be NA, but that may not be true (is likely not) in the case of geno files.}

\item{write}{Boolean. Whether or not to write the output to files in the current working directory. There will be two files, one for the individual loadings and the other for the percent variance explained by each axis.}

\item{prefix}{Character. Optional argument. String that will be appended to file output. Please provide a prefix if write is set to TRUE.}
}
\value{
A list containing two elements: the loadings of individuals on each principal component and the variance explained by each principal component.
}
\description{
A function to perform principal component analysis (PCA) on genetic data. Loci with missing data will be removed prior to PCA.
}
\examples{
\donttest{
data("HornedLizard_VCF")
Test <- PCA(data = HornedLizard_VCF)}
}
\author{
Keaka Farleigh
}
