% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FunctionsClinicalTrial.R
\name{waldCI}
\alias{waldCI}
\title{Wald confidence interval estimation}
\usage{
waldCI(vaccinated, control, confLevel = 0.95)
}
\arguments{
\item{vaccinated}{\code{Population-class} object: vaccinated subjects, containing information about disease status}

\item{control}{\code{Population-class} object: control subjects, containing information about disease status}

\item{confLevel}{numeric: value from (0, 1) interval, confidence level of interest}
}
\value{
Named list of lower and upper confidence interval bound
}
\description{
Function calculates and returns case-count efficacy confidence intervals estimated using Wald's method.

Input data need to contain information about disease status on individual level.
}
\details{
Confidence interval of the relative risk is calculated using the Wald method. (Wald, A. Tests of statistical hypotheses concerning several parameters when the number of observations is large. Transactions of the American Mathematical Society 54, 426-482 (1943)).
}
\examples{
# Loading vaccinated and control populations data with PoD information
data(vaccinated)
data(control)

# Estimating the disease status and case-count efficacy with 95\\% confidence interval
set.seed(1)
CT <- ClinicalTrial(vaccinated, control, CI = 0.95)

waldCI(vaccinated, control)

}
