% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FunctionsPoDParameters.R
\name{GenerateNondiseased}
\alias{GenerateNondiseased}
\title{Generation of upsampled non-diseased subjects titers}
\usage{
GenerateNondiseased(blindNondiseasedTiters, nondiseasedCount)
}
\arguments{
\item{blindNondiseasedTiters}{numeric vector: vector of non-diseased subjects titer values}

\item{nondiseasedCount}{numeric: total number of non-diseased subjects, required size of the non-diseased population}
}
\value{
nondiseasedTiters: numeric vector of all non-diseased subjects titers
}
\description{
Function upsamples (by random sampling with replacement) titers from the immunogenicity subset to the required size.

If the size of the immunogenicity subset matches the required size, nothing happens and the original titers from the immunogenicity subset are returned.
}
\details{
The inputs should come from immunogenicity subset. "nondiseasedCount" represents number of all non-diseased patients in the clinical trial.

Immunogenicity subset populations are obtained from function \code{BlindSampling}. Immunogenicity subset represents a sample from the non-diseased population.

In this function, sampling with replacement to the required "nondiseasedCount" of the immunogenecitry subset is performed. The function is used inside \code{PoDParamEstimation} function.
}
\examples{
## Data preparation
data(nondiseased)

## Example 1
# Creating imunogenicity subset, method = "Full"
NondiseasedImmunogenicitySubset <- 
    ImmunogenicitySubset(diseased, 
                         nondiseased, 
                         method = list(name = "Full", 
                                       value = "NA"))

# Number of all non-diseased subjects in the clinical trial
nondiseasedGenerationCount <- nondiseased$N

# Upsampling of non-diseased titers
GenerateNondiseased(NondiseasedImmunogenicitySubset$titers, nondiseasedGenerationCount)

}
