% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FunctionsPODBAYEfficacy.R
\name{ExpectedPoD}
\alias{ExpectedPoD}
\title{Expected probability of disease}
\usage{
ExpectedPoD(f.pod, f.titer)
}
\arguments{
\item{f.pod}{function(x):  PoD curve, estimated sigmoid function relating titers to a probability of disease}

\item{f.titer}{function(x): titer probability density function, distribution of titer values in a group.}
}
\value{
Value of the integral of the multiplication of the two functions
}
\description{
Function calculates the integral of multiplication of two functions: PoD curve and titer probability density function.
}
\details{
Function calculates integral from -Inf to +Inf of titer probability density function multiplied by the PoD curve.

It is used mainly in the PoDBAY efficacy calculation \code{efficacyComputation}.
}
\examples{
# Example 1 
data(vaccinated)
data(control)
data(PoDParams)

# Defining the PoD curve
funPoD <- function(x) PoD(x, pmax = PoDParams$pmax, et50 = PoDParams$et50, slope = PoDParams$slope)

# Defining the titer distribution for vaccinated and control groups
funVaccinated <- function(x) dnorm(x, mean = vaccinated$mean, sd = vaccinated$stdDev)
funControl <- function(x) dnorm(x, mean = control$mean, sd = control$stdDev)

# Calculating the expected probability of disease 
aucVaccinated <- ExpectedPoD(funPoD, funVaccinated)
aucControl <- ExpectedPoD(funPoD, funControl)

# PoDBAY efficacy estimation
efficacy <- 1 - aucVaccinated/aucControl

}
