% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FunctionsClinicalTrial.R
\name{ClinicalTrialCoverage}
\alias{ClinicalTrialCoverage}
\title{Clinical trial function expanded for usage in simulations when the calculation of coverage probability is needed for three confidence intervals: 80\%, 90\%, and user-defined}
\usage{
ClinicalTrialCoverage(vaccinated, control, CI = 0.95)
}
\arguments{
\item{vaccinated}{\code{Population-class} object: vaccinated subjects with assigned PoD}

\item{control}{\code{Population-class} object: control subjects with assigned PoD}

\item{CI}{numeric: value from (0, 1) interval, confidence level of interest}
}
\value{
\itemize{
  \item vaccinated: vaccinated subjects with assigned DS, \code{Population-class} object

  \item control: control subjects with assigned DS, \code{Population-class} object

  \item efficacy: case-count efficacy

  \item confidenceInterval: confidence interval calculated with \code{waldCI} function

  \item confidenceInterval90: 90\% confidence interval calculated with \code{waldCI} function

  \item confidenceInterval80: 80\% confidence interval calculated with \code{waldCI} function
}
}
\description{
Function works the same way as \code{ClinicalTrial} function but it also calculates 80\% and 90\% confidence intervals.
}
