% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaryData.R
\name{summaryData}
\alias{summaryData}
\title{Summarize Classified Wear Time by Daily Basis}
\usage{
summaryData(
  data,
  validCut = getOption("pa.validCut"),
  perMinuteCts = 1,
  markingString = "w",
  TS = getOption("pa.timeStamp"),
  cts = getOption("pa.cts"),
  delivery = NULL,
  deliveryCut = 0.5
)
}
\arguments{
\item{data}{Data with classified wear (nonwear) status by
\code{\link{wearingMarking}}.}

\item{validCut}{A cutoff for the total minutes of classified monitor wear
time per day to be considered as a valid monitor day.}

\item{perMinuteCts}{The number of data rows per minute. The default is 1-min
epoch (perMinuteCts = 1) and we recommend to use 1-min epoch data for this
summary. For examples: for data with 10-sec epoch, set perMinuteCts = 6; for
data with 1-sec epoch, set perMinuteCts = 60.}

\item{markingString}{Option for summarizing wear (markingString = \dQuote{w}) or
nonwear time (markingString = \dQuote{nw}).}

\item{TS}{The column name for timestamp. The default is \dQuote{TimeStamp}.}

\item{cts}{The name of the counts column. The default is \dQuote{axis1}.}

\item{delivery}{data.frame. Delivery information created by
\code{\link{markDelivery}} or \code{\link{deliveryPrediction}}.}

\item{deliveryCut}{A cutoff (probability) to consider a valid delivery date.
See the \code{\link{deliveryPrediction}} function. The default value is 0.5.}
}
\value{
\item{unit}{epoch for data.}
\item{totalNumDays}{the total number of days in accelerometer data.}
\item{totalNumWeekWeekend}{the total number of weekdays and weekend days in
accelerometer data.}
\item{validCut}{a user defined cutoff for the total minutes of classified
monitor wear time per day to be considered as a valid monitor day.}
\item{totalValidNumDays}{the total number of valid days based on the user defined 
cutoff (\dQuote{validCut}) for the total minutes of wear time and the classified wear time.}
\item{totalValidNumWeekWeekend}{the total number of valid weekdays and valid
weekend days based on the user defined cutoff (\dQuote{validCut}) for the total minutes of
classified monitor wear time per day.}
\item{wearTimeByDay}{the classified total wear (nonwear) time by day.}
\item{deliveryDays}{marked delivery days.}
\item{validWearTimeByDay}{the classified total wear (nonwear) time by valid
day.}
\item{meanWeartimeValidDays}{the mean wear (nonwear) time for valid days
during weekdays and weekends.}
\item{meanWeartimeOverallValidDays}{the mean wear (nonwear) time for overall
valid days.}
\item{dayInfo}{information about wear time and mean counts for each day.}
\item{intensity}{optional output depending on \dQuote{pai} column in the data; 
the total time in hours of physical activity intensity by day.}
\item{meanValidIntensity}{optional output depending on \dQuote{pai} column in the data; 
the mean physical activity intensity (PAI) level for valid days.}
}
\description{
This function summarizes accelerometer data and the classified wear or nonwear
time by daily basis.
}
\details{
This function summarizes the total number of days, weekdays and weekend days 
in accelerometer data. It provides the total number of valid days,
valid weekdays and valid weekend days based on a user defined cutoff
for the total minutes of classified monitor wear time per day. This function
also summarizes the classified wear (nonwear) time by day and by valid day,
and the mean wear (nonwear) time for valid days during weekday and weekends,
and for overall valid days. If mail delivery days are classified by 
\code{\link{markDelivery}}, it also summarizes the classified delivery
(non-delivery) days with argument \dQuote{delivery}.
If \dQuote{pai} column is present in the data, 
which can be created by \code{\link{markPAI}}, then physical activity intensity
(PAI) level will be summarized in the output.
}
\examples{
data(dataSec)

mydata1m = dataCollapser(dataSec, TS = "TimeStamp", col = "counts", by = 60)

data1m = wearingMarking(dataset = mydata1m,
                       frame = 90, 
                       perMinuteCts = 1,
                       TS = "TimeStamp",
                       cts = "counts", 
                       streamFrame = NULL, 
                       allowanceFrame= 2, 
                       newcolname = "wearing")

summaryData(data=data1m, validCut=600, perMinuteCts=1, markingString = "w", cts = "counts")

data(deliveryData)
options(pa.cts = "vm")
wm <- wearingMarking(dataset = deliveryData)
dd <- markDelivery(wm)
pdd <- deliveryPred(wm)
summaryData(wm, delivery = dd)
summaryData(wm, delivery = pdd)

pai.data <- markPAI(data = wm)
dd <- markDelivery(pai.data)
summaryData(pai.data, delivery = dd)

}
\references{
Choi L, Liu Z, Matthews CE, Buchowski MS. 
Validation of accelerometer wear and nonwear time classification algorithm.
Med Sci Sports Exerc. 2011 Feb;43(2):357-64.
}
\seealso{
\code{\link{wearingMarking}}, \code{\link{sumVct}},
\code{\link{markPAI}}, \code{\link{markDelivery}}
}
\author{
Cole Beck \email{cole.beck@vumc.org},
Leena Choi \email{leena.choi@Vanderbilt.Edu}
}
