#' Validate Phone Number
#'
#' Sends a phone number to the GenderAPI.io Phone Validation & Formatter API to validate its structure, detect type (mobile, landline, Voice over Internet Protocol (VoIP)), retrieve region metadata, and format into standard formats. Visit (<https://www.genderapi.io>) to get free API KEY
#'
#' @param api_key Your GenderAPI.io API key as a Bearer token.
#' @param number The phone number string to validate (in local or international format).
#' @param address Optional. A free-form location string (e.g., city, country) to assist with parsing and validation.
#'
#' @return A list with phone number validation results including validity, formatting, region, and type information.
#' @export
validate <- function(api_key, number, address = "") {
  url <- "https://api.genderapi.io/api/phone"

  payload <- list(
    number = number,
    address = address
  )

  payload <- payload[!sapply(payload, is.null)]

  res <- httr::POST(
    url,
    httr::add_headers(
      Authorization = paste("Bearer", api_key),
      `Content-Type` = "application/json"
    ),
    body = jsonlite::toJSON(payload, auto_unbox = TRUE)
  )

  status <- httr::status_code(res)

  if (status %in% c(200, 404)) {
    return(httr::content(res, as = "parsed"))
  } else {
    stop(paste("Unknown error. HTTP status:", status))
  }
}
