% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createphenotypeFunctions.R
\name{transformNonlinear}
\alias{transformNonlinear}
\title{Phenotype transformation.}
\usage{
transformNonlinear(
  component,
  alpha,
  method,
  logbase = 10,
  power = 2,
  expbase = NULL,
  transformNeg = "abs",
  f = NULL,
  verbose = TRUE
)
}
\arguments{
\item{component}{[N x P] Phenotype matrix [double] where [N] are the number 
of samples and P the number of phenotypes}

\item{alpha}{[double] weighting scalar for non-linearity: alpha==0 fully
linear phenotype, alpha==1 fully non-linear phenotype. See @details.}

\item{method}{[string] one of exp (exponential), log (logarithm), poly
(polynomial), sqrt (squareroot) or custom (user-supplied function)}

\item{logbase}{[int] when method==log, sets the log base for transformation}

\item{power}{[double] when method==poly, sets the power to raise to.}

\item{expbase}{[double] when method==exp, sets the exp base for
transformation.}

\item{transformNeg}{[string] one of abs (absolute value) or set0 (set all 
negative values to zero). If method==log and transformNeg==set0, negative
values set to 1e-5}

\item{f}{[function] function accepting component as a single argument.}

\item{verbose}{[boolean]; If TRUE, progress info is printed to standard out.}
}
\value{
[N x P] transformed phenotype matrix [double]
}
\description{
Transformation of phenotype component by applying a user-specified 
non-linear transformation to the phenotype component.
}
\details{
transformNonlinear takes a phenotype component as input and 
transforms it according to the specified transformation method. The user can 
choose how strongly non-linear the resulting phenotype component should be, 
by specifying the weighting parameter alpha:
component_transformed = (1 - alpha) \* component + 
alpha \* transformfunction(component)
}
\examples{
# Simulate non-genetic covariate effects 
cov_effects <- noiseFixedEffects(N=100, P=5)
# Transform logarithmically
covs_log <- transformNonlinear(cov_effects$shared, alpha=0.5, method="log",
transformNeg="abs")
# Transform custom
f_custom <- function(x) {x^2 + 3*x}
covs_custom <- transformNonlinear(cov_effects$shared, alpha=0.5, 
method="custom", f=f_custom)
}
