% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilityFunctions.R
\name{expGen2probGen}
\alias{expGen2probGen}
\title{Rewrite expected genotypes into genotype probabilities.}
\usage{
expGen2probGen(geno)
}
\arguments{
\item{geno}{Vector [numeric] with genotypes}
}
\value{
Numeric vector of length [length(geno)*3] with the genotype encoded 
as probabbilities (p(AA), p(Aa), p(aa)).
}
\description{
Convert genotype frequencies to genotypes encoded as triplets of probablities 
(p(AA), p(Aa), p(aa)).
}
\examples{
nrSamples <- 10
# Simulate binomial SNP with 0.2 allele frequency
geno <- rbinom(nrSamples, 2, p=0.2)
geno_prob<- expGen2probGen(geno)
}
