% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_SDS.R
\name{predict_SDS}
\alias{predict_SDS}
\title{Predict Spectral Disease Severity (SDS)}
\usage{
predict_SDS(cleaned_data, sf_test, fixed_effects = NULL)
}
\arguments{
\item{cleaned_data}{A dataframe containing spectral measurements and treatment labels.}

\item{sf_test}{A dataframe containing selected important features (from statistical tests).}

\item{fixed_effects}{A character vector of fixed effects to include (default: NULL).
Example: c("Scan.date").}
}
\value{
A dataframe with predicted SDS values for all treatments, constrained between \code{0} and \code{100}.
}
\description{
This function predicts Spectral Disease Severity (SDS) using a standard linear regression model (\code{lm()}).
It automatically handles column names with special characters by using backticks and constrains predictions to the range \verb{[0, 100]}.
}
\examples{
# Create mock spectral data
library(openxlsx)
cleaned_data <- data.frame(
  treatment = sample(0:1, 100, replace = TRUE),
  var1 = rnorm(100),
  var2 = rnorm(100),
  var3 = rnorm(100),
  Scan.date = sample(
    seq.Date(
      from = as.Date('2023-01-01'),
      to = as.Date('2023-12-31'),
      by = 'day'
    ),
    100
  ),
  Scan.time = format(Sys.time(), "\%H:\%M:\%S")
)
}
