% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SFM.coefficients.R
\name{SFM.coefficients}
\alias{SFM.coefficients}
\title{Calculate single factor model alpha and beta coefficients}
\usage{
SFM.coefficients(
  Ra,
  Rb,
  Rf = 0,
  subset = TRUE,
  ...,
  method = "Robust",
  family = "mopt",
  digits = 3,
  benchmarkCols = T,
  Model = F,
  warning = T
)
}
\arguments{
\item{Ra}{an xts, vector, matrix, data frame, timeSeries or zoo object of
asset returns}

\item{Rb}{return vector of the benchmark asset}

\item{Rf}{risk free rate, in same period as your returns}

\item{subset}{a logical vector representing the set of observations to be used in regression}

\item{\dots}{Other parameters like max.it or bb specific to lmrobdetMM regression. Another
interesting parameter is round.by.alphas, and round.by.betas which can be set to round off the 
returned values, otherwise the values}

\item{method}{(Optional): string representing linear regression model, "LS" for Least Squares
and "Robust" for robust. Defaults to "LS}

\item{family}{(Optional): 
If method == "Robust": 
  This is a string specifying the name of the family of loss function
  to be used (current valid options are "bisquare", "opt" and "mopt").
  Incomplete entries will be matched to the current valid options. 
  Defaults to "mopt".
Else: the parameter is ignored}

\item{digits}{(Optional): Number of digits to round the results to. Defaults to 3.}

\item{benchmarkCols}{(Optional): Boolean to show the benchmarks as columns. Defaults to TRUE.}

\item{Model}{(Optional): Boolean to return the fitted model. Defaults to FALSE}

\item{warning}{(Optional): Boolean to show warnings or not. Defaults to TRUE.}
}
\description{
The single factor model is the beta of an asset to the variance 
and covariance of an initial portfolio. Used to determine diversification potential.
"Alpha" purports to be a measure of a manager's skill by measuring the
portion of the managers returns that are not attributable to "Beta", or the
portion of performance attributable to a benchmark.
}
\details{
This function is designed to be used a a wrapper for SFM's regression models. 
Using this, one can easily fit different types of linear models 
like Ordinary Least Squares or Robust Estimators like Huber.

\deqn{\beta_{a,b}=\frac{CoV_{a,b}}{\sigma_{b}}=\frac{\sum((R_{a}-\bar{R_{a}})(R_{b}-\bar{R_{b}}))}{\sum(R_{b}-\bar{R_{b}})^{2}}}{beta
= cov(Ra,Rb)/var(R)}

Ruppert(2004) reports that this equation will give the estimated slope of
the linear regression of \eqn{R_{a}}{Ra} on \eqn{R_{b}}{Rb} and that this
slope can be used to determine the risk premium or excess expected return
(see Eq. 7.9 and 7.10, p. 230-231).
}
\examples{
if(requireNamespace("RobStatTM", quietly = TRUE)) { # CRAN requires conditional execution
  data(managers)
  SFM.coefficients(managers[,1], managers[,8]) 
  SFM.coefficients(managers[,1:6], managers[,8:9], Rf = managers[,10])
	 SFM.coefficients(managers[,1:6], managers[,8:9], 
			     Rf=.035/12, method="Robust", 
			     family="mopt", bb=0.25, 
			     max.it=200)
} # CRAN requires conditional execution
}
\references{
Sharpe, W.F. Capital Asset Prices: A theory of market
equilibrium under conditions of risk. \emph{Journal of finance}, vol 19,
1964, 425-442. \cr Ruppert, David. \emph{Statistics and Finance, an
Introduction}. Springer. 2004. \cr Bacon, Carl. \emph{Practical portfolio
performance measurement and attribution}. Wiley. 2004. \cr
}
\seealso{
\code{\link{BetaCoVariance}} \code{\link{SFM.alpha}}
\code{\link{CAPM.utils}} \code{\link{SFM.beta}}
}
\author{
Dhairya Jain
}
