% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IO.R
\name{parse_flows}
\alias{parse_flows}
\title{Parse the information from a 'flows' definition table.}
\usage{
parse_flows(flows, verbose = FALSE)
}
\arguments{
\item{flows}{data.frame containing the nodes definition}

\item{verbose}{logical: print some information?}
}
\value{
modified flows data.frame
}
\description{
This function checks the content of a flows definition,
and appends some missing columns.
It is mainly used internally, but can be invoked by the uses to see what it does.
}
\examples{
Q0 <- data.frame(from="A", to="B", qty=10) # Note 'qty' as alias for quantity
str(Q0)
Q1 <- parse_flows(Q0)
str(Q1)
}
