
## `PakNAcc`: Shiny App for National Accounts

###### Version : [0.2.0](https://myaseen208.com/PakNAcc/); Copyright (C) 2024: License: [GPL-2\|GPL-3](https://www.r-project.org/Licenses/)

##### *Muhammad Yaseen<sup>1,2</sup>, and Zahid Asghar<sup>3</sup>*

1.  [School of Mathematical & Statistical Sciences, Clemson University,
    Clemson, South Carolina,
    USA](https://www.clemson.edu/science/academics/departments/mathstat/about/profiles/myaseen)
2.  Department of Mathematics and Statistics, University of Agriculture
    Faisalabad, Pakistan
3.  [School of Economics, Quaid-i-Azam University, Islamabad,
    Pakistan](https://zahidasghar.com/)

------------------------------------------------------------------------

[![minimal R
version](https://img.shields.io/badge/R%3E%3D-3.5.0-6666ff.svg)](https://cran.r-project.org/)
[![License: GPL
v3](https://img.shields.io/badge/License-GPL%20v3-blue.svg)](https://www.gnu.org/licenses/gpl-3.0)
[![CRAN_Status_Badge](https://www.r-pkg.org/badges/version-last-release/PakNAcc)](https://cran.r-project.org/package=PakNAcc)
[![rstudio mirror
downloads](https://cranlogs.r-pkg.org/badges/grand-total/PakNAcc?color=green)](https://CRAN.R-project.org/package=PakNAcc)
<!-- [![packageversion](https://img.shields.io/badge/Package%20version-0.2.3.3-orange.svg)](https://github.com/myaseen208/PakNAcc) -->

[![develVersion](https://img.shields.io/badge/devel%20version-0.1.0-orange.svg)](https://github.com/myaseen208/PakNAcc)

<!-- [![GitHub Download Count](https://github-basic-badges.herokuapp.com/downloads/myaseen208/PakNAcc/total.svg)] -->

[![Project Status:
WIP](https://www.repostatus.org/badges/latest/inactive.svg)](https://www.repostatus.org/#inactive)
[![lifecycle](https://img.shields.io/badge/lifecycle-stable-brightgreen.svg)](https://lifecycle.r-lib.org/articles/stages.html#stable)
[![Last-changedate](https://img.shields.io/badge/last%20change-2024--11--12-yellowgreen.svg)](https://github.com/myaseen208/PakNAcc)
\*\*\*

## Description

Provides a comprehensive suite of tools for analyzing Pakistan’s
Quarterly National Accounts data. Users can gain detailed insights into
Pakistan’s economic performance, visualize quarterly trends, and detect
patterns and anomalies in key economic indicators. Compare sector
contributions—including agriculture, industry, and services—to
understand their influence on economic growth or decline. Customize
analyses by filtering and manipulating data to focus on specific areas
of interest. Ideal for policymakers, researchers, and analysts aiming to
make informed, data-driven decisions based on timely and detailed
economic insights.

## Installation

The package can be installed from CRAN as follows:

``` r
install.packages("PakNAcc", dependencies = TRUE)
```

The development version can be installed from github as follows:

``` r
if (!require("remotes")) install.packages("remotes")
remotes::install_github("myaseen208/PakNAcc")
```

## What’s new

To know whats new in this version type:

``` r
news(package = "PakNAcc")
```

## Links

[Shiny App](https://myaseen208.shinyapps.io/PakNAcc/)

[CRAN page](https://cran.r-project.org/package=PakNAcc)

[Github page](https://github.com/myaseen208/PakNAcc)

[Documentation website](https://myaseen208.com/PakNAcc/)

## Citing `PakNAcc`

To cite the methods in the package use:

``` r
citation("PakNAcc")
Please, support this project by citing it in your publications!

  Yaseen M, Asghar Z (2024). _PakNAcc: Shiny App for National
  Accounts_.

A BibTeX entry for LaTeX users is

  @Manual{,
    title = {PakNAcc: Shiny App for National Accounts},
    author = {Muhammad Yaseen and Zahid Asghar},
    year = {2024},
    journal = {The Comprehensive R Archive Network (CRAN)},
  }
```
