% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fp.lm.R
\name{fp.lm}
\alias{fp.lm}
\title{Linear Fractional Power Adsorption Kinetic Model}
\usage{
fp.lm(t, qt, qe)
}
\arguments{
\item{t}{the numerical value for contact time. This parameter should not contain a value equal to zero to prevent infinite value. Any row(s) that contain(s) value of t equal to zero will be automatically removed to proceed with the calculation.}

\item{qt}{the numerical value for the amount adsorbed at time t. This parameter should not contain a value equal to zero to prevent incalculable value. Any row(s) that contain(s) value of qt equal to zero will be automatically removed to proceed with the calculation.}

\item{qe}{the numerical value for the amount adsorbed at equilibrium}
}
\value{
the linear regression and the parameter estimation for the Fractional Power model
}
\description{
The Fractional Power Adsorption Kinetic Model is an empirical rate equation in which the specific adsorption rate at a unit time can be estimated using its product's constant. The model was first used to explain the adsorption kinetics of phosphate in soils by anion exchange resin. It is also called the modified Freundlich equation (Netzahuatl-Muñoz, Del Carmen Cristiani-Urbina, and Cristiani-Urbina, 2015).
}
\examples{
t <- c(0,15,30,45,60,75,90,105,120)
qt <-c(0.000,3.718,3.888,4.102,4.274,4.402,4.444,4.488,4.616)
qe <- 4.8
fp.lm(t,qt,qe)
}
\references{
Dalai, R. C. (1974) <doi: 10.1080/00103627409366531> Desorption of soil phosphate by anion-exchange resin. Communications in Soil Science and Plant Analysis, 5(6), 531-538.

Netzahuatl-Munoz, A. R., del Carmen Cristiani-Urbina, M., &; Cristiani-Urbina, E. (2015) <doi:10.1371/journal.pone.0137086> Chromium Biosorption from Cr(VI) aqueous solutions by Cupressus lusitanica bark: Kinetics, equilibrium and thermodynamic studies. PLoS ONE, 10(9).
}
\author{
Jeff Ryan S. Magalong

Joshua Z. Dela Cruz

Jeann M. Bumatay

Chester C. Deocaris
}
