% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcn_plots.R
\name{plot_MBRAlign}
\alias{plot_MBRAlign}
\title{Plot MaxQuant Match-between-runs alignment performance.}
\usage{
plot_MBRAlign(data, y_lim, title_sub, match_tol)
}
\arguments{
\item{data}{A data.frame with columns as described above}

\item{y_lim}{Plot range of y-axis}

\item{title_sub}{Subtitle}

\item{match_tol}{Maximal residual RT delta to reference (usually ~1 min)}
}
\value{
GGplot object
}
\description{
The plots shows the correction function applied by MaxQuant, and the
residual RT (ideally 0) of each peptide to its reference. Uncalibrated peptides
are shown in red, calibrated ones in green.
The MaxQuant RT correction which was applied prior is shown in blue. The range of this function
can give hints if the allowed RT search window (20min by default) is sufficient or if
MaxQuant should be re-run with more tolerant settings.
}
\details{
The input is a data.frame with columns
  'calibrated.retention.time' - resulting (hopefully) calibratated RT after MQ-recal (the X-axis of the plot)
  'retention.time.calibration' - delta applied by MaxQuant
  'rtdiff' - remaining RT diff to reference peptide of the same sequence
  'RTdiff_in' - is the feature aligned (within 'match_tol')?
  'fc.raw.file_ext' - raw file
where each row represents one peptide whose RT was corrected by MaxQuant.
}
\examples{

 data = data.frame(fc.raw.file_ext = "file A", ## more than one would be possible
                   calibrated.retention.time = c(20:100),
                   retention.time.calibration = 6 + sin((20:100)/10))
 data$rtdiff = rnorm(nrow(data))
 data$RTdiff_in = c("green", "red")[1 + (abs(data$rtdiff) > 0.7)]

 plot_MBRAlign(data, c(-10, 10), "fancy subtitle", 0.7)

}
