% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{plot_coefficients}
\alias{plot_coefficients}
\title{Plot coefficients, standard errors, and p-values against the transition variable}
\usage{
plot_coefficients(obj, vars, length.out = 100, color = "blue", size = 1.5)
}
\arguments{
\item{obj}{An object of class \code{"PSTR"}.}

\item{vars}{A vector of column indices or variable names from the nonlinear part.}

\item{length.out}{Number of grid points over the transition variable.}

\item{color}{Line colour.}

\item{size}{Line width.}
}
\value{
A named list of \code{ggplot2} objects.
}
\description{
This function plots three curves against the transition variable:
the coefficient function, its standard error, and the corresponding p-value.
}
\details{
For each selected variable \eqn{j}, the curves are
\deqn{f_1(x) = \beta_{0j} + \beta_{1j} g(x;\gamma,c)}
\deqn{f_2(x) = se\{f_1(x)\}}
\deqn{f_3(x) = 1 - \Pr\left\{X < \left[f_1(x)/f_2(x)\right]^2\right\}}
where \eqn{X} follows a chi-square distribution with one degree of freedom.

In addition to the exported function \code{plot_coefficients(obj = ...)},
the same functionality is available as an R6 method via
\code{obj$plot_coefficients(...)}.
}
\examples{
\donttest{
pstr <- NewPSTR(Hansen99, dep = "inva", indep = 4:20,
                indep_k = c("vala","debta","cfa","sales"),
                tvars = c("vala","debta","cfa","sales"), iT = 14)

pstr <- EstPSTR(use = pstr, im = 1, iq = 1,
                useDelta = TRUE, par = c(.63,0), method = "CG")

# Exported function
ret <- plot_coefficients(pstr, vars = 1:4)

# R6 method
ret2 <- pstr$plot_coefficients(vars = 1:4)
}

}
