% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Mod4.test.R
\name{Mod4.test}
\alias{Mod4.test}
\title{Modular test for independence in four-way contingency table}
\usage{
Mod4.test(nijtu, B = 10000)
}
\arguments{
\item{nijtu}{a numeric matrix with non-negative values of the four-way contingency table cells}

\item{B}{an integer specifying the number of replicates used in the Monte Carlo test (optional)}
}
\value{
The function returns values of the test statistic and p-value of the modular test.
}
\description{
Calculates the test statistic and p-value of the modular test for independence in four-way contingency table
}
\details{
The test statistic and p-value of the modular test for independence in r x c x t x u contingency table,
}
\examples{
\donttest{Mod4.test(GenTab4(array(1/16, dim = c(2, 2, 2, 2)), 160), B = 1e2)}
\donttest{Mod4.test(table6, B = 1e2)}

}
\references{
Extension of the information contained in {Sulewski, P. (2018). \emph{Power Analysis Of Independence Testing for the Three-Way Con-tingency Tables of Small Sizes.} Journal of Applied Statistics 45(13), 2481-2498}
}
\author{
Piotr Sulewski, \email{piotr.sulewski@apsl.edu.pl}, Pomeranian University in Slupsk.
}
