% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Lms4.stat.R
\name{Lms4.stat}
\alias{Lms4.stat}
\title{Logarithmic minimum test for independence in four-way contingency table}
\usage{
Lms4.stat(nijtu)
}
\arguments{
\item{nijtu}{a numeric matrix with non-negative values of the four-way contingency table cells}
}
\value{
The function returns the value of the logarithmic minimum test statistic.
}
\description{
Calculates the statistic of the Logarithmic minimum test for independence in four-way contingency table
}
\details{
The statistic of Logarithmic minimum test for independence in r x c x t x u contingency table,
}
\examples{
Lms4.stat(GenTab4(array(1/16, dim = c(2, 2, 2, 2)), 160))
Lms4.stat(table5)

}
\references{
Extension of the information contained in {Sulewski, P. (2021). \emph{Logarithmic Minimum Test for Independence in Three Way Con-tingency Table of Small Sizes,} Journal of Statistical Computation and Simulation 91(13), 2780-2799}
}
\author{
Piotr Sulewski, \email{piotr.sulewski@apsl.edu.pl}, Pomeranian University in Slupsk.
}
