## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## -----------------------------------------------------------------------------
library(PSIndependenceTest)
dim(table1)
length(table2)

## -----------------------------------------------------------------------------
GenTab2(matrix(1/8, nrow = 2, ncol = 4), 50)
GenTab2(matrix(1/12, nrow = 4, ncol = 3), 60)

## -----------------------------------------------------------------------------
Mod2.stat(table1)
Mod2.stat(GenTab2(matrix(1/9, nrow = 3, ncol = 3), 90))

## -----------------------------------------------------------------------------
Mod2.cv(2, 2, 40, 0.05, B = 1e3) 
Mod2.cv(2, 3, 60, 0.1) 

## -----------------------------------------------------------------------------
Mod2.pvalue(Mod2.stat(table1), 2, 2, 40, B = 1e3)
Mod2.pvalue(Mod2.stat(table2), 2, 3, 60)

## -----------------------------------------------------------------------------
Mod2.test(table1, B = 1e3)
Mod2.test(table2)

## -----------------------------------------------------------------------------
Lms2.stat(table1)
Lms2.stat(GenTab2(matrix(1/9, nrow = 3, ncol = 3), 90))

## -----------------------------------------------------------------------------
Lms2.cv(2, 2, 40, 0.05, B = 1e3) 
Lms2.cv(2, 3, 60, 0.1)  

## -----------------------------------------------------------------------------
Lms2.pvalue(Lms2.stat(table1), 2, 2, 40, B = 1e3)
Lms2.pvalue(Lms2.stat(table2), 2, 3, 60)

## -----------------------------------------------------------------------------
Lms2.test(table1, B = 1e3)
Lms2.test(table2)

## -----------------------------------------------------------------------------
GenTab3(array(1/12, dim=c(2,2,3)), 60)
GenTab3(array(1/18, dim=c(2,3,3)), 80)

## -----------------------------------------------------------------------------
Mod3.stat(table3)
Mod3.stat(GenTab3(array(1/12, dim=c(2,2,3)), 120))

## -----------------------------------------------------------------------------
Mod3.cv(2, 2, 2, 80, 0.05, B = 1e3) 
Mod3.cv(2, 2, 2, 80, 0.1) 

## -----------------------------------------------------------------------------
Mod3.pvalue(Mod3.stat(table4), 2, 2, 2, 80, B = 1e3)
Mod3.pvalue(Mod3.stat(table4), 2, 2, 2, 80)

## -----------------------------------------------------------------------------
Mod3.test(table4, B = 1e2)
Mod3.test(table4, B = 1e3)

## -----------------------------------------------------------------------------
Lms3.stat(table3)
Lms3.stat(GenTab3(array(1/12, dim=c(2,2,3)), 120))

## -----------------------------------------------------------------------------
Lms3.cv(2, 2, 2, 80, 0.05, B = 1e2) 
Lms3.cv(2, 2, 2, 80, 0.1, B = 1e3) 

## -----------------------------------------------------------------------------
Lms3.pvalue(Lms3.stat(table4), 2, 2, 2, 80, B = 1e3)
Lms3.pvalue(Lms3.stat(table4), 2, 2, 2, 80)

## -----------------------------------------------------------------------------
Lms3.test(table4, B = 1e2)
Lms3.test(table4, B = 1e3)

## -----------------------------------------------------------------------------
GenTab4(array(1/16, dim=c(2,2,2,2)), 100)
GenTab4(array(1/36, dim=c(2,3,2,3)), 150)

## -----------------------------------------------------------------------------
Mod4.stat(table5)
Mod4.stat(table6)

## -----------------------------------------------------------------------------
Mod4.cv(2, 2, 2, 2, 160, 0.05, B = 1e2)
Mod4.cv(2, 2, 2, 2, 160, 0.1, B = 1e3)

## -----------------------------------------------------------------------------
Mod4.pvalue(Mod4.stat(table6), 2, 2, 2, 2, 160, B = 1e2)
Mod4.pvalue(Mod4.stat(table6), 2, 2, 2, 2, 160, B = 1e3)

## -----------------------------------------------------------------------------
Mod4.test(table6, B = 1e2)
Mod4.test(table6, B = 1e3)

## -----------------------------------------------------------------------------
Lms4.stat(table5)
Lms4.stat(table6)

## -----------------------------------------------------------------------------
Lms4.cv(2, 2, 2, 2, 160, 0.05, B = 1e2)
Lms4.cv(2, 2, 2, 2, 160, 0.1, B = 1e3)

## -----------------------------------------------------------------------------
Lms4.pvalue(Lms4.stat(table6), 2, 2, 2, 2, 160, B = 1e2)
Lms4.pvalue(Lms4.stat(table6), 2, 2, 2, 2, 160, B = 1e3)

## -----------------------------------------------------------------------------
Lms4.test(table6, B = 1e2)
Lms4.test(table6, B = 1e3)

