test_that("`.lmFit()` handles intercept only properly", {
  
  y <- withr::with_seed(1234L,
                        rnorm(1000))
  res <- y - mean(y)
  names(res) <- 1L:1000L
  s2 <- drop(crossprod(res))
  P0 <- diag(1000L) - matrix(1.0 / 1000, 1000, 1000)
  
  expected <- list("P0" = P0, "res" = res, "s2" = s2)

  expect_equal(.lmFit(y, matrix(1, 1000, 0)),
               expected)
})