% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p.pca.R
\name{p.pca}
\alias{p.pca}
\title{Visualize predictors using principal coordinate analysis}
\usage{
p.pca(x, y, method = "linear", lower.thr = 0, n.pred = ncol(x), size = 1)
}
\arguments{
\item{x}{A data matrix (row: samples, col: predictors).}

\item{y}{A vector of an environment in which the samples were collected.}

\item{method}{A string to specify the method of regression for calculating R-squared values.
"linear" (default), "quadratic" or "cubic" regression model can be specified.}

\item{lower.thr}{The lower threshold of R-squared value to be indicated in a PCA plot (default: 0).}

\item{n.pred}{The number of candidate predictors for PLORN model to be indicated in a PCA plot (default: ncol(x)).}

\item{size}{The size of symbols in a PCA plot (default: 1).}
}
\value{
A PCA plot
}
\description{
Visualize predictors using principal coordinate analysis
}
\examples{
data(Pinus)
train <- p.clean(Pinus$train)
target <- Pinus$target
p.pca(train, target)
}
\author{
Takahiko Koizumi
}
