% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OneComp_Volume_Clearance_HalfLife.R
\name{OneComp_Volume_Clearance_HalfLife}
\alias{OneComp_Volume_Clearance_HalfLife}
\title{Convert pharmacokinetic parameters for one compartment model}
\usage{
OneComp_Volume_Clearance_HalfLife(Cl1,t_alpha,
         Cl1.sd=NA,t_alpha.sd=NA,covar=c(Cl1talpha=NA),...)
}
\arguments{
\item{Cl1}{Clearance from compartment 1}

\item{t_alpha}{half life of compartment 1}

\item{Cl1.sd}{standard error of Cl1}

\item{t_alpha.sd}{standard error of t_alpha}

\item{covar}{covariances among parameters}

\item{...}{arguments to be passed to methods}
}
\description{
Calculate pharmacokinetic parameters with clearance (Cl1) and
half-life (t_alpha)
}
\examples{
OneComp_Volume_Clearance_HalfLife(Cl1=4,t_alpha=0.568,
      Cl1.sd=0.01,t_alpha.sd=0.0003)
}
\references{
\url{http://www.nonmemcourse.com/convert.xls}
}
