% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCBN-restrictions.R
\name{DAG_to_restrictedDAG}
\alias{DAG_to_restrictedDAG}
\alias{fix_active_cycles}
\alias{fix_interfering_vstructs}
\title{Turns a general graph into a restricted graph.}
\usage{
DAG_to_restrictedDAG(DAG)

fix_active_cycles(DAG, active_cycles_list = NULL)

fix_interfering_vstructs(DAG, all_B_sets = NULL)
}
\arguments{
\item{DAG}{a directed acyclic graph object, of class \code{bn}.}

\item{active_cycles_list, all_B_sets}{respective outputs of the functions
\code{\link{active_cycles}} and \code{\link{find_B_sets}}.
If they are \code{NULL}, the respective function is called to compute them.}
}
\value{
Restricted DAG.
}
\description{
Turns a general graph into a restricted graph.
}
\examples{
# DAG with an active cycle at node 5
DAG = create_empty_DAG(5)
DAG = bnlearn::set.arc(DAG, 'U1', 'U3')
DAG = bnlearn::set.arc(DAG, 'U1', 'U2')
DAG = bnlearn::set.arc(DAG, 'U2', 'U4')
DAG = bnlearn::set.arc(DAG, 'U3', 'U5')
DAG = bnlearn::set.arc(DAG, 'U4', 'U5')

# Fixed graph has extra arcs 1 -> 5, 2 -> 5
fixed_DAG = DAG_to_restrictedDAG(DAG)


# DAG with an interfering v-structures node 3
DAG = create_empty_DAG(5)
DAG = bnlearn::set.arc(DAG, 'U1', 'U3')
DAG = bnlearn::set.arc(DAG, 'U1', 'U4')
DAG = bnlearn::set.arc(DAG, 'U2', 'U3')
DAG = bnlearn::set.arc(DAG, 'U2', 'U5')
DAG = bnlearn::set.arc(DAG, 'U3', 'U4')
DAG = bnlearn::set.arc(DAG, 'U3', 'U5')

# Fixed graph has extra arc 1 -> 5
fixed_DAG = DAG_to_restrictedDAG(DAG)

}
\seealso{
\code{\link{is_restrictedDAG}} to check whether a given DAG is
restricted.
}
