% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mduration.R
\name{mduration}
\alias{mduration}
\title{Estimate mean duration of response}
\usage{
mduration(
  t2PROGRESSION,
  STATUS_PROGRESSION,
  t2RESPONSE,
  STATUS_RESPONSE,
  time.max = -1
)
}
\arguments{
\item{t2PROGRESSION}{time to progression/death or censoring}

\item{STATUS_PROGRESSION}{binary indicator for progression/death status: 1 for progression/death; 0 for censoring}

\item{t2RESPONSE}{time to response or censoring}

\item{STATUS_RESPONSE}{binary indicator for response status: 1 for response; 0 for censoring}

\item{time.max}{maximum time point, up to which the mean DOR is to be estimated; the default value corresponds to the maximum time window in which the mean DOR is estimable}
}
\value{
A list with following elements
\itemize{
\item{meandor.est:}  the restricted mean DOR estimate
\item{meandor.se:}   the standard error of the esimated DOR
\item{time.truncation:}     the truncation time point used in DOR.
}
}
\description{
Estimate mean duration of response
}
\details{
The mean duration of response restricted within a time window is also the area under the PBIR curve over the same time window. The estimated mean duration can be viewed as a global summary of the PBIR curve. One may compare the mean duration of response between two groups, which is also a global comparison between two PBIR curves.
}
\examples{

library(survival)
n=100
set.seed(10)

# Generate the data

error=rnorm(n)
tr=exp(rnorm(n)+error+0.5)
tp=exp(rnorm(n)+error)
tr[tp<tr]=Inf
tc=runif(n, 3, 8.5)
t2response=pmin(tr, tc)
delta_response=1*(tr<tc)
t2progression=pmin(tp, tc)
delta_progression=1*(tp<tc)

# Estimate the mean duration of response (point estimator and its standard error)

fit=mduration(t2PROGRESSION=t2progression,
              STATUS_PROGRESSION=delta_progression,
              t2RESPONSE=t2response,
              STATUS_RESPONSE=delta_response,
              time.max=8)

fit
}
\references{
Huang, B., Tian, L., Talukder, E., Rothenberg, M., Kim, DY., and Wei, LJ. (2018) Evaluating Treatment Effect Based on Duration of Response for a Comparative Oncology Study. JAMA Oncol, doi: 10.1001/jamaoncol.2018.0275

Huang, B., Tian, L., McCaw, Z., Luo, Talukder, E., X., Rothenberg, M., Xie, W., Choueiri, T., Kim, DY., & Wei, LJ. (2020). Analysis of Response Data for Assessing Treatment Effects in Comparative Clinical Studies. Ann Intern Med, doi: 10.7326/M20-0104.
}
