% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pam.coxph.R
\name{pam.coxph}
\alias{pam.coxph}
\title{Prediction Accuracy Measures for Cox proportional hazards model}
\usage{
pam.coxph(fit.cox)
}
\arguments{
\item{fit.cox}{object inheriting from class coxph representing a fitted Cox proportional hazards
regression model. Specifying x = TRUE and y=TRUE are required in the call to coxph( )
to include the design matrix and the response vector in the object fit.}
}
\value{
A list containing two components: R-squared and L-squared
}
\description{
This function calculates a pair of measures, R-Squared and L-Squared, for Cox proportional hazards model. R-squared is an extension of the classical R2 statistic for a linear model, quantifying the amount of variability in the response that is explained by a corrected prediction based on the original prediction function. L-squared is the proportion of the prediction error of the original prediction function that is explained by the corrected prediction function, quantifying the distance between the corrected and uncorrected predictions. When used together, they give a complete summary of the predictive power of a prediction function.
}
\examples{
library(survival)
library(PAmeasures)

# Use Mayo Clinic Primary Biliary Cirrhosis Data
data(pbc)

head(pbc)


# Fit a univariate Cox PH model with standardised blood clotting time
fit1 <- coxph(Surv(time, status==2) ~ protime, data = pbc,x=TRUE,y=TRUE)

# R.squared and L.squared of Cox PH model
pam.coxph(fit1)

# Fit a multiple Cox PH model with bilirubin and standardised blood clotting time
fit2 <- coxph(Surv(time, status==2) ~ bili + protime, data = pbc,x=TRUE,y=TRUE)

# R.squared and L.squared of Cox PH model
pam.coxph(fit2)
}
