% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pam.censor.R
\name{pam.censor}
\alias{pam.censor}
\title{Prediction Accuracy Measures for Regression Models of Right-Censored Data}
\usage{
pam.censor(y, y.predict, delta)
}
\arguments{
\item{y}{A numeric vector containing the response values.}

\item{y.predict}{A numeric vector containing the predicted response values from a fitted model.}

\item{delta}{A numeric vector indicating the status of the event, normally 0=alive, 1=dead.}
}
\value{
A list containing two components: R-squared and L-squared
}
\description{
This function calculates a pair of measures, R-Squared and L-Squared, for any regression models of right-censored data. R-squared is an extension of the classical R2 statistic for a linear model, quantifying the amount of variability in the response that is explained by a corrected prediction based on the original prediction function. L-squared is the proportion of the prediction error of the original prediction function that is explained by the corrected prediction function, quantifying the distance between the corrected and uncorrected predictions. When used together, they give a complete summary of the predictive power of a prediction function.
}
\examples{
library(survival)
library(PAmeasures)

# Use Mayo Clinic Primary Biliary Cirrhosis Data
data(pbc)

# Fit an exponential model with bilirubin
fit1 <- survreg(Surv(time, status==2) ~ bili, data = pbc,dist="exponential" )

# Obtain predicted response from the fitted exponential model
predict.time<-predict(fit1,type="response")

# Recode status at endpoint, 0 for censored, 1 for dead
delta.pbc<- as.numeric(pbc$status == 2)

# R.squared and L.squared of log-linear model
pam.censor(pbc$time, predict.time, delta.pbc)
}
