% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PASWR-package.R
\docType{data}
\name{Tire}
\alias{Tire}
\title{Tire Stopping Distances}
\format{
A data frame with 24 observations on the following 2 variables:
\describe{
\item{StopDist}{stopping distance measured to the nearest foot} 
\item{tire}{a factor with levels \code{A}, \code{B}, \code{C},
and \code{D}} 
}
}
\source{
Ugarte, M. D., Militino, A. F., and Arnholt, A. T. (2008)
\emph{Probability and Statistics with R}. Chapman & Hall/CRC.
}
\description{
The data frame \code{Tire} has the stopping distances measured to the
nearest foot for a standard sized car to come to a complete stop from a
speed of sixty miles per hour. There are six measurements of the stopping
distance for four different tread patterns labeled A, B, C, and D. The same
driver and car were used for all twenty-four measurements. Data are used in
Example 11.1 and 11.2.
}
\examples{

summary(aov(StopDist ~ tire, data = Tire))

}
\keyword{datasets}
