% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binDetectionData.R
\name{binDetectionData}
\alias{binDetectionData}
\title{Bin Detection Data to Time Bins}
\usage{
binDetectionData(
  x,
  bin,
  columns = c("species"),
  rematchGPS = TRUE,
  gpsGroup = NULL
)
}
\arguments{
\item{x}{dataframe of detection data}

\item{bin}{the amount time to bin by, must be a character of the form
\code{"#unit"} or \code{"unit"} e.g. "2hour" or "day"}

\item{columns}{names of the columns in \code{x} that define which rows
should still be considered distinct even if their times are in the same
bin. For example, two calls from the same species in one hour should result
in one row of hourly presence, but two calls from different species in one
hour should result in two separate rows of hourly presence.}

\item{rematchGPS}{logical flag, if \code{TRUE} then if columns Longitude
and Latitude are present in \code{x} then they will be rematched to
the outputs. Note that this is imprecise - the time used for rematching
the outputs is the center of each output time bin.}

\item{gpsGroup}{the name of the column in \code{x} that denotes different
GPS groupings within the data, usually something like "site" or
"deployment." Not needed if all data are from the same location.}
}
\value{
a dataframe where each row represents detection presence of
one time unit
}
\description{
Transforms detection data to presence-type data with user
specified time bin (e.g. hourly or daily presence).
}
\examples{
dets <- data.frame(
   UTC = as.POSIXct(c('2020-04-04 12:20:00', '2020-04-04 12:40:00', '2020-04-04 13:20:00')),
   species = c('whale', 'whale', 'dolphin'),
   call = c('a', 'b', 'c'))
# two rows of outputs
binDetectionData(dets, bin='1hour', columns='species')
# adding "call" creates 3 rows of outputs
binDetectionData(dets, bin='1hour', columns=c('species', 'call'))

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
