% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OneArmTTEAnalysis.R
\name{OneArmTTEAnalysis}
\alias{OneArmTTEAnalysis}
\title{Perform analysis on the data of one-arm clinical trial with time-to-event endpoint}
\usage{
OneArmTTEAnalysis(
  data,
  eventRates.ctrl,
  landmark,
  RWdata = NULL,
  RWSurvCal = FALSE,
  conf.type = "plain",
  alpha = 0.05
)
}
\arguments{
\item{data}{Trial data. A tibble/data.frame containing \code{time} and \code{censor}, where \code{censor=1} indicates event.}

\item{eventRates.ctrl}{Event rates of historical control.}

\item{landmark}{The landmark of interest to evaluate the survival rate for Landmark Kaplan-Meier method and binary method.}

\item{RWdata}{The real world data to be used as external control; A tibble/data.frame containing \code{time} and \code{censor}, where \code{censor=1} indicates event; default is NULL.}

\item{RWSurvCal}{Indicator of whether to calculate historical cumulative hazard and survival rate at landmark from real world data; default is FALSE.}

\item{conf.type}{Type of confidence interval in the survival model; One of "\code{none}", "\code{plain}" (the default), "\code{log}", "\code{log-log}", "\code{logit}" or "\code{arcsin}".}

\item{alpha}{Type I error rate level.}
}
\value{
No visible return values.
}
\description{
This function can get analysis results on the input trial data using several approaches for
one-arm trial design with time-to-event endpoint. Default approaches include one-sample log-rank
test, Landmark Kaplen-Meier method and binary method which regards the survival of each subject
at a landmark is a binary variable. In addition, if \code{RWdata} is not \code{NULL}, the \code{RWdata}
input will be used as an external control and cox model will be used to evaluate the treatment effect
of input trial data (experimental arm) compared with the external control.
}
\details{
This function outputs a list of analysis results of each design, including:
         1) p-value of one-sample log-rank test,
         2) historical survival rate at landmark,
         3) survival rate estimate with confidence interval of landmark kaplan-meier method,
         4) survival rate estimate with confidence interval of binary method,
         5) p-value of binary method,
         6) hazard ratio estimate with confidence interval compared with real world data (if available),
         7) p-value of log-rank test compared with real world data (if available).
}
\examples{
\donttest{
library(survival)
data(example_data)
# Piecewise exponential of historical control
median.ctrl <- c(14.3, 1.5, 4.9)
eventRates.ctrl <- tibble::tibble(duration=c(4,2,100),rate=log(2)/median.ctrl)
OneArmTTEAnalysis(example_data, eventRates.ctrl, landmark=6)
}
}
