% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R
\name{addObjects}
\alias{addObjects}
\title{Add objects}
\usage{
addObjects(study, objects, reset = FALSE)
}
\arguments{
\item{study}{An OmicNavigator study created with \code{\link{createStudy}}}

\item{objects}{Any arbitrary R objects from the study. The input object is a
list of objects (one per model). To share an object across multiple models,
use the modelID "default".}

\item{reset}{Reset the data prior to adding the new data (default:
\code{FALSE}). The default is to add to or modify any previously added data
(if it exists). Setting \code{reset = TRUE} enables you to remove existing
data you no longer want to include in the study.}
}
\description{
Experimental. Add arbitrary R objects to a study. These will be exported via
\code{\link[base]{saveRDS}} and imported via \code{\link[base]{readRDS}}.
This allows preserving the exact structure of complex R objects.
}
\details{
The main purpose of adding a custom object to your study package is to use it
in custom plots in the app. If available, they will be returned by
\code{\link{getPlottingData}}. If the custom package requires additional R
packages to be available to use, make sure to list these packages in the
field \code{packages} when adding the custom plotting function via
\code{\link{addPlots}}.
}
\seealso{
\code{\link{getObjects}},
\code{\link[base]{saveRDS}},
\code{\link[base]{readRDS}}
}
