\name{pkpd}
\title{Pharmacokinetic models}
\usage{
mu1.0o1c(p, times, dose=1, end=0.5)
mu1.1o1c(p, times, dose=1)
mu1.1o2c(p, times, dose=1)
mu1.1o2cl(p, times, dose=1)
mu1.1o2cc(p, times, dose=1)
mu2.0o1c(p, times, dose=1, ind, end=0.5)
mu2.1o1c(p, times, dose=1, ind)
mu2.0o1cfp(p, times, dose=1, ind, end=0.5)
mu2.1o1cfp(p, times, dose=1, ind)
}
\arguments{
\item{p}{Vector of parameters. See the source file for details.}
\item{times}{Vector of times.}
\item{dose}{Vector of dose levels.}
\item{ind}{Indicator whether parent drug or metabolite.}
\item{end}{Time infusion ends.}
}
\description{
Mean functions for using in fitting pharmacokinetic models with
\code{\link{gnlr}} and \code{\link{gnlmm}}.

\code{mu1.0o1c}: open zero-order one-compartment model

\code{mu1.1o1c}: open first-order one-compartment model

\code{mu1.1o2c}: open first-order two-compartment model (ordered)

\code{mu1.1o2cl}: open first-order two-compartment model (ordered,
	absorption and transfer equal)

\code{mu1.1o2cc}: open first-order two-compartment model (circular)

Simultaneous models for parent drug and metabolite:

\code{mu2.0o1c}: zero-order one-compartment model

\code{mu2.1o1c}: first-order one-compartment model

\code{mu2.0o1cfp}: zero-order one-compartment first-pass model

\code{mu2.1o1cfp}: first-order one-compartment first-pass model
}
\value{
The profile of mean concentrations for the given times and doses is
returned.
}
\examples{
# set up a mean function for gnlr:
mu <- function(p) mu2.0o1c(p, times, doses, ind)
shape <- function(p) ind*p[1]+(1-ind)*p[2]
gnlr(resp, "gamma", mu=mu, pmu=c(1.68,-1.15,-4.33,-0.15,-3.46),
	shape=shape, pshape=c(0.2,0.1))
# changing variance
shape2 <- function(p) p[6]*log(mu2.0o1c(p, times, doses, ind))
gnlr(resp, "gamma", mu=mu, pmu=c(1.7,-1.2,-4.3,-0.1,-3.5),
	shape=shape2, pshape=c(-0.2,-3.5,-1.6,-1,1,0.5))
# for logged responses such as a log normal distribution:
mul <- function(p) log(mu2.0o1c(p, times, doses, ind))
gnlr(log(resp), "normal", mu=mul, pmu=c(1.7,-1.2,-4.3,-0.1,-3.5),
	shape=shape, pshape=c(2,1), delta=1/resp)
}
