\name{gnlr3}
\title{Fit a Generalized Nonlinear Regression Model for Three
Parameter Distributions}
\usage{
gnlr3(y, dist="normal", pmu=NULL, pshape=NULL, pfamily=NULL,
	mu=NULL, shape=NULL, family=NULL, linear=NULL, censor=F,
	exact=F, wt=1, delta=1, print.level=0, typsiz=abs(p),
	ndigit=10, gradtol=0.00001, stepmax=10*sqrt(p\%*\%p),
	steptol=0.00001, iterlim=100, fscale=1)
}
\alias{gnlr3}
\alias{coefficients.gnlr3}
\alias{deviance.gnlr3}
\alias{df.residual.gnlr3}
\alias{fitted.values.gnlr3}
\alias{residuals.gnlr3}
\alias{weights.gnlr3}
\arguments{
\item{y}{The response vector for uncensored data. For censored data,
two columns with the second being the censoring indicator (1:
uncensored, 0: right censored, -1: left censored.) It may also be an
object of class, response.}
\item{dist}{Either a character string containing the name of the
distribution or a function giving the -log likelihood and calling the
location and shape functions.}
\item{pmu}{Vector of initial estimates for the location parameters.}
\item{pshape}{Vector of initial estimates for the shape parameters.}
\item{pfamily}{Vector of initial estimates for the family parameters.}
\item{mu}{User-specified function of \code{pmu}, and possibly \code{linear},
giving the regression equation for the location. This may contain a linear
part that is the second argument to the function. It may also be a
language expression beginning with ~, specifying a linear regression
function for the location parameter. If neither is supplied, the
location is taken to be constant unless the linear argument is given.}
\item{shape}{User-specified function of \code{pshape}, and possibly
\code{linear}, giving the regression equation for the dispersion or shape
parameter. This may contain a linear part that is the second argument
to the function. It may also be a language expression beginning with
~, specifying a linear regression function for the shape parameter. If
neither is supplied, this parameter is taken to be constant unless the
linear argument is given. This parameter is the logarithm of the usual
one.}
\item{family}{User-specified function of \code{pfamily}, and possibly
\code{linear}, for the regression equation of the third (family)
parameter of the distribution. This may contain a linear part that is
the second argument to the function. It may also be a language
expression beginning with ~, specifying a linear regression function
for the family parameter. If neither is supplied, this parameter is
taken to be constant unless the linear argument is given. This
parameter is the logarithm of the usual one.}
\item{linear}{Language expression beginning with ~, specifying the
linear part of the regression function for the location parameters
or list of three such expressions for the location, shape, and/or
family parameters.}
\item{exact}{If TRUE, fits the exact likelihood function for
continuous data by integration over intervals of observation,
i.e. interval censoring.}
\item{wt}{Weight vector.}
\item{delta}{Scalar or vector giving the unit of measurement (always
one for discrete data) for each response value, set to unity by
default - for example, if a response is measured to two decimals,
delta=0.01. If the response is transformed, this must be multiplied by
the Jacobian. The transformation cannot contain unknown
parameters. For example, with a log transformation,
\code{delta=1/y}. (The delta values for the censored response are
ignored.)}
\item{others}{Arguments controlling \code{\link{nlm}}.}
}
\description{
\code{gnlr3} fits user specified nonlinear regression equations to one,
two, or all three parameters of three parameter distributions
(Box-Cox transformed normal, generalized inverse Gauss, generalized
logistic, Hjorth, generalized gamma, Burr, generalized Weibull,
power exponential, Student t, and generalized extreme value).
}
\value{
A list of class gnlr is returned.
The printed output includes the -log likelihood (not the deviance),
the corresponding AIC, the maximum likelihood estimates, standard
errors, and correlations. A list is returned that contains all of the
relevant information calculated, including error codes.
}
\seealso{
\code{\link{lm}}, \code{\link{glm}}, \code{\link{gnlr}}, \code{\link{fmr}}.
}
\examples{
# linear regression with the generalized inverse Gauss distribution
mu <- function(p) p[1]+p[2]*sex+p[3]*age
gnlr3(data, dist="inverse Gauss", pmu=rep(1,3), psh=1, pfam=1, mu=mu)
# or equivalently
gnlr3(data, dist="inverse Gauss", pmu=rep(1,3), psh=1, pfam=1,
	mu=~sex+age)
# or
gnlr3(data, dist="inverse Gauss", pmu=rep(1,3), psh=1, pfam=1,
	linear=~sex+age)
#
# nonlinear regression with generalized inverse Gauss distribution
mu <- function(p, linear) p[4]*exp(linear)
gnlr3(data, dist="inverse Gauss", pmu=rep(1,4), psh=1, pfam=1, mu=mu,
	linear=~sex+age)
#
# include regression for the shape parameter with same mu function
shape <- function(p) p[5]+p[6]*sex+p[7]*age
gnlr3(data, dist="inverse Gauss", pmu=rep(1,4), psh=rep(1,3), pfam=1,
	mu=mu, shape=shape)
# or equivalently
gnlr3(data, dist="inverse Gauss", pmu=rep(1,4), psh=rep(1,3), pfam=1,
	mu=mu, linear=list(~sex+age,~sex+age))
# include regression for the family parameter with same mu
# and shape functions
family <- function(p) p[8]+p[9]*sex+p[10]*age
gnlr3(data, dist="inverse Gauss", pmu=rep(1,4), psh=rep(1,3),
	pfam=rep(1,3), mu=mu, shape=shape, family=shape)
# or equivalently
gnlr3(data, dist="inverse Gauss", pmu=rep(1,4), psh=rep(1,3),
	pfam=rep(1,3), mu=mu, linear=list(~sex+age,~sex+age,~sex+age))
}
