% file MASS/menarche.d
% copyright (C) 1994-9 W. N. Venables and B. D. Ripley
%
\name{menarche}
\alias{menarche}
\title{
Age of Menarche data
}
\section{SUMMARY}{
Proportions of female children at various ages during adolescence
who have reached menarche.
}
\section{DATA DESCRIPTION}{
This data frame contains the following columns:
}
\arguments{
\item{Age}{
Average age of the group.  (The groups are reasonably age homogeneous.)
}
\item{Total}{
Total number of children in the group.
}
\item{Menarche}{
Number who have reached menarche.
}}
\section{SOURCE}{
Milicer, H. \& Szczotka, F. (1966) Age at Menarche in Warsaw girls in
1965. 
\emph{Human Biology}
\bold{38}, 199-203.


The data are also given in 
Aranda-Ordaz, F.J. (1981) 
On two families of transformations to additivity for binary response data.
\emph{Biometrika,}
\bold{68}, 357-363.
}
\examples{
data(menarche)
mprob <- glm(cbind(Menarche, Total - Menarche) ~ Age, 
		binomial(link = probit), menarche)
}
\keyword{datasets}
% Converted by Sd2Rd version 0.3-2.
