% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EstimationQueries.R
\name{getCmOutcomes}
\alias{getCmOutcomes}
\title{A function to extract the outcomes found in cohort method}
\usage{
getCmOutcomes(
  connectionHandler,
  schema,
  cmTablePrefix = "cm_",
  cgTablePrefix = "cg_",
  targetId = NULL
)
}
\arguments{
\item{connectionHandler}{A connection handler that connects to the database and extracts sql queries.  Create a connection handler via `ResultModelManager::ConnectionHandler$new()`.}

\item{schema}{The result database schema (e.g., 'main' for sqlite)}

\item{cmTablePrefix}{The prefix used for the cohort method results tables}

\item{cgTablePrefix}{The prefix used for the cohort generator results tables}

\item{targetId}{An integer corresponding to the target cohort ID}
}
\value{
A data.frame with the cohort method outcome ids and names.
}
\description{
A function to extract the outcomes found in cohort method
}
\details{
Specify the connectionHandler, the schema and the prefixes
}
\examples{
conDet <- getExampleConnectionDetails()

connectionHandler <- ResultModelManager::ConnectionHandler$new(conDet)

outcomes <- getCmOutcomes(
  connectionHandler = connectionHandler, 
  schema = 'main'
)

}
\seealso{
Other Estimation: 
\code{\link{getCMEstimation}()},
\code{\link{getCmDiagnosticsData}()},
\code{\link{getCmMetaEstimation}()},
\code{\link{getCmNegativeControlEstimates}()},
\code{\link{getCmPropensityModel}()},
\code{\link{getCmTable}()},
\code{\link{getCmTargets}()},
\code{\link{getSccsDiagnosticsData}()},
\code{\link{getSccsEstimation}()},
\code{\link{getSccsMetaEstimation}()},
\code{\link{getSccsModel}()},
\code{\link{getSccsNegativeControlEstimates}()},
\code{\link{getSccsOutcomes}()},
\code{\link{getSccsTable}()},
\code{\link{getSccsTargets}()},
\code{\link{getSccsTimeToEvent}()},
\code{\link{plotCmEstimates}()},
\code{\link{plotSccsEstimates}()}
}
\concept{Estimation}
