% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pte.R
\name{pte.survival}
\alias{pte.survival}
\title{Estimates the proportion of treatment effect explained}
\usage{
pte.survival(xob, s.ob, deltaob, aob, t, t.0, varind = 0, re = 100)
}
\arguments{
\item{xob}{observed survival time}

\item{s.ob}{surrogate information at time t.0}

\item{deltaob}{event indicator}

\item{aob}{treatment indicator}

\item{t}{time at which the primary outcome is measured}

\item{t.0}{time at which the surrogate is measured}

\item{varind}{whether to estimate variance (yes=0, no=1)}

\item{re}{number of replications for resampling, if varind=0}
}
\value{
A list of the following:
\item{pte.est}{The estimated proportion of treatment effect explained (PTE) by the optimally transformed surrogate}
\item{pte.ese}{Standard error estimate for the PTE, provided if var.ind=0}
\item{g1.est}{Estimated g1}
\item{g1.ese}{Standard error estimate for ge, provided if var.ind = 0}
\item{sgrid}{Grid used for the surrogate marker, equally spaced}
\item{gs.est}{Estimated g(s), optimal transformation of s, for the sgrid}
\item{gs.ese}{Standard error estimate for g(s), provided if var.ind = 0}
}
\description{
Estimates the proportion of treatment effect explained by the optimally transformed surrogate
}
\examples{
# load the data
data("sysdata")

# time at which the surrogate is measured
t.0 = data.example$t.0

# time at which the primary outcome is measured
t = data.example$t

# observed survival time
xob = data.example$data$xob

# surrogate information at t.0
s.ob = data.example$data$s.ob

# event indicator
deltaob = data.example$data$deltaob

# treatment indicator
aob = data.example$data$aob

# main estimation function
# varind: whether to estimate variance; re:number of replications for resampling
out = pte.survival(xob, s.ob, deltaob, aob, t, t.0, varind=0, re=100)

# estimated PTE
out$pte.est

# estimated g1
out$g1.est

# estimated g2(s) at equally spaced s point
plot(out$sgrid, out$gs.est, type="l", xlab = "Surrogate Marker", ylab = "Optimal Transformation")
#The PTE result indicates that this is a moderate to high surrogate marker in this setting.
}
