% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trainTree.R
\name{trainTree}
\alias{trainTree}
\title{trainTree Function}
\usage{
trainTree(PatientData, PatientSensitivity, minbucket = 20)
}
\arguments{
\item{PatientData}{A matrix representing patient features, where rows correspond to patients/samples
and columns correspond to genes/features. This matrix can contain:
\itemize{
  \item Binary mutation data (e.g., presence/absence of mutations).
  \item Continuous data from gene expression profiles (e.g., expression levels).
}}

\item{PatientSensitivity}{A matrix representing drug response values, where rows correspond to patients
in the same order as in `PatientData`, and columns correspond to drugs. Higher values indicate greater drug resistance and, consequently, 
lower sensitivity to treatment. This matrix can represent various measures of drug 
response, such as IC50 values or area under the drug response curve (AUC). Depending 
on the interpretation of these values, users may need to adjust the sign of this data.}

\item{minbucket}{An integer specifying the minimum number of patients required in a node to allow for a split.}
}
\value{
An object of class 'party' representing the trained decision tree, with the assigned treatments for each node.
}
\description{
This function trains a decision tree model based on patient data, which can either be gene expression levels or a binary matrix indicating mutations.
}
\examples{

\donttest{
  # Basic example of using the trainTree function with mutational data
  data("drug_response_w12")
  data("mutations_w12")
  ODTmut <- trainTree(PatientData = mutations_w12, 
                      PatientSensitivity = drug_response_w12,
                      minbucket = 10)
  plot(ODTmut)

  # Example using gene expression data instead
  data("drug_response_w34")
  data("expression_w34")
  ODTExp <- trainTree(PatientData = expression_w34,
                      PatientSensitivity = drug_response_w34,
                      minbucket = 20)
  plot(ODTExp)
}

}
