% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{sim_NVAR}
\alias{sim_NVAR}
\title{Time series simulation with an NVAR model}
\usage{
sim_NVAR(
  model,
  init = NULL,
  length = 1000,
  noise = 0,
  upper_lim = Inf,
  lower_lim = -Inf
)
}
\arguments{
\item{model}{An \code{NVAR} model, fitted by \code{\link[=NVAR]{NVAR()}}.}

\item{init}{A \code{tibble}, data.frame, or matrix that specify the initial values for a simulation. Should contain the variables used to fit the model and be at least \eqn{s * (k - 1)} long. \code{NULL} by default, in which case the data used for fitting the model will be used for simulation.}

\item{length}{How many time steps should be simulated? \code{1e3} by default.}

\item{noise}{A number indicating the standard deviation of the Gaussian noise
added to each time step. \code{0} by default (no noise).}

\item{upper_lim, lower_lim}{The upper and lower limit for the simulation. Once the simulated value is out of the limits, it will be taken back to avoid instability of the simulation. Both should either be a single number or a numeric vector with the same length as the number of variables in the model. \code{Inf} and \code{-Inf} by default, which means no limits.}
}
\value{
A \code{tibble} with the simulated time series.
}
\description{
Time series simulation with an NVAR model
}
