#' Calculate Fertilizer N Recovery Efficiency (NRE)
#' @description
#' The percentage of fertilizer N that is taken up by the plant.
#' Formula: NRE = ((PlantNf - PlantN0) / FertN) * 100
#' @param PlantNf A numeric vector of plant N in fertilized conditions.
#' @param PlantN0 A numeric vector of plant N in control conditions.
#' @param FertN A numeric value or vector for fertilizer N input.
#' @return A numeric vector of NRE percentages.
#' @examples
#' PlantNf <- c(3.5, 4.0, 4.2)
#' PlantN0 <- c(2.0, 2.0, 2.0)
#' FertN <- 50
#' NRE(PlantNf, PlantN0, FertN)
#' @export
NRE <- function(PlantNf, PlantN0, FertN) {
  if (any(FertN == 0)) stop("FertN cannot be zero.")
  
  NRE_val <- ((PlantNf - PlantN0) / FertN) * 100
  return(NRE_val)
}