test_that("norma_gene_core runs on valid multi-condition data",{
  X<-cbind(
    g1=c(26,24,27,28,26,27),
    g2=c(21,20,22,20,19,22),
    g3=c(28,27,29,26,27,27),
    g4=c(32,31,34,30,30,35),
    g5=c(18,17,19,17,18,20)
  )

  cond<-factor(c("A","A","A","B","B","B"))

  res<-norma_gene_core(X, conditions=cond)

  expect_type(res, "list")
  expect_named(res, c("norm", "cor_fact", "rel_var"))
  expect_equal(dim(res$norm), dim(X))
})

test_that("norma_gene_core allows NA values",{
  X<-cbind(
    g1=c(26,NA,27,28,26,27),
    g2=c(21,20,22,20,19,22),
    g3=c(28,27,29,26,27,27),
    g4=c(32,31,34,30,30,35),
    g5=c(18,17,19,17,18,20)
  )

  cond<-factor(c("A","A","A","B","B","B"))

  expect_silent(norma_gene_core(X, conditions=cond))
})

test_that("norma_gene_core runs on valid single-condition data",{
  X<-cbind(
    g1=c(26,24,27,28),
    g2=c(21,20,22,20),
    g3=c(28,27,29,26),
    g4=c(32,31,34,30),
    g5=c(18,17,19,17)
  )

  #Explicitly single-condition case
  expect_warning(
    res<-norma_gene_core(X, conditions=NULL),
    "`conditions` is NULL"
  )

  expect_type(res, "list")
  expect_named(res, c("norm", "cor_fact", "rel_var"))
  expect_equal(dim(res$norm), dim(X))
})

test_that("norma_gene_core errors if a condition has fewer than two replicates",{
  X<-cbind(
    g1=c(26,24),
    g2=c(21,20),
    g3=c(28,27),
    g4=c(32,31),
    g5=c(18,17)
  )

  cond<-factor(c("A","B"))

  expect_error(
    norma_gene_core(X, conditions=cond),
    "At least two replicates per condition"
  )
})

