test_that("relative_variability returns by_gene matrix",{
  data(multi_cond_data)

  res<-norma_gene(
    data=multi_cond_data,
    conditions="Diagnosis",
    replicates="Sample_id"
  )

  rv<-relative_variability(res, type="by_gene")

  expect_type(rv, "double")
  expect_true(is.matrix(rv))
})

test_that("relative_variability returns by_condition vector",{
  data(multi_cond_data)

  res<-norma_gene(
    data=multi_cond_data,
    conditions="Diagnosis",
    replicates="Sample_id"
  )

  rv<-relative_variability(res, type="by_condition")

  expect_type(rv, "double")
  expect_named(rv)
})

test_that("correction_factors returns named vector",{
  data(multi_cond_data)

  res<-norma_gene(
    data=multi_cond_data,
    conditions="Diagnosis",
    replicates="Sample_id"
  )

  cf<-correction_factors(res)

  expect_type(cf, "double")
  expect_named(cf)
  expect_length(cf, nrow(multi_cond_data))
})
