% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relative_variability.R
\name{relative_variability}
\alias{relative_variability}
\title{Retrieve relative variability metrics from NORMAgene output}
\usage{
relative_variability(x, type = c("by_gene", "by_condition"))
}
\arguments{
\item{x}{An object returned by \code{\link[=norma_gene]{norma_gene()}}.}

\item{type}{Character string specifying which relative variability metric to return. One of \code{"by_gene"} or \code{"by_condition"}.}
}
\value{
Depending on \code{type}:
\describe{
\item{by_gene}{A named numeric matrix of gene-level relative variability values, calculated both within experimental conditions and cumulatively across all experimental conditions.}
\item{by_condition}{A named numeric vector of relative variability calculated within experimental conditions, as well as cumulatively across all experimental conditions, regardless of gene.}
}
}
\description{
Retrieves relative variability metrics calculated during normalization.
}
\details{
For more information on relative variability metrics, see \link{NORMAgene-package}.
}
\examples{
# load example dataset containing raw CT values and
# metadata from a multi-condition experiment

data(multi_cond_data)
raw_data<-multi_cond_data

#normalize CT values via NORMAgene

norm_data<-norma_gene(
  data = raw_data,
  conditions = "Diagnosis",
  replicates= "Sample_id"
)

# retrieve relative variability metrics

relative_variability(norm_data, type = "by_gene")
relative_variability(norm_data, type = "by_condition")

}
\seealso{
\code{\link[=norma_gene]{norma_gene()}} \cr
\link{NORMAgene-package}
}
