% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correction_factors.R
\name{correction_factors}
\alias{correction_factors}
\title{Retrieve scaling factors from NORMAgene output}
\usage{
correction_factors(x)
}
\arguments{
\item{x}{An object returned by \code{\link[=norma_gene]{norma_gene()}}.}
}
\value{
A numeric vector of correction factors. If replicate identifiers were passed to \code{\link[=norma_gene]{norma_gene()}}, the vector is named accordingly.
}
\description{
Retrieves the per-replicate scaling factors used for normalization.
}
\examples{
# load example dataset containing raw CT values and
# metadata from a multi-condition experiment

data(multi_cond_data)
raw_data<-multi_cond_data

#normalize CT values via NORMAgene

norm_data<-norma_gene(
  data = raw_data,
  conditions = "Diagnosis",
  replicates= "Sample_id"
)

# retrieve scaling factors

correction_factors(norm_data)

}
\seealso{
\code{\link[=norma_gene]{norma_gene()}}
}
