\name{data_NPP}
\alias{data_NPP}
\docType{data}
\title{data_NPP}
\description{A list with variety of example datasets
}
\usage{data(data_NPP)}
\details{
A list with the following elements:

\strong{Alcohol_Intake} is data from a meta-analysis on 36 effect sizes (Hedges g values) for the effect of  
manipulations of social influences on perceived norms regarding alcohol intake and on
reductions in alcohol intake (Prestwich, Kellar, Conner, 
Lawton, Gardner,& Turgut, 2016, Table 2, p. 850).

\strong{Anxiety_Therapy} is data from a meta-analysis on 81 effect sizes (Hedges g values) for the  
pre-post difference between transdiagnostic cognitive behavior therapy and anxiety 
(Pearl & Norton, 2017, Figure 2, p. 14).
	
\strong{Cannabis_Psychosis} is data from a meta-analysis on 38 effect sizes (standardized mean 
differences) from comparisons of the age at onset of psychosis in 
cannabis-using groups with the age at onset of psychosis in 
noncannabis-using groups (Large et al., 2001). The data are from the 
"eFigure" in the Supplementary Material.
	
\strong{CBT_Autism} is data from Weston, Hodgekins, and Langdon (2016), who reported findings  
from a meta-analysis of 17 studies on the effectiveness of CBT on affective 
symptoms for people with autistic spectrum disorders (median N = 36). 
The final effect size, in correlation coefficient metric, was .11.

\strong{CBT_Social_Anxiety} is data from Kampmanna, Emmelkamp, and Morina (2016, Figure 4),
who reported findings 
from a meta-analysis of 24 studies on internet delivered cognitive behavior 
therapy (vs. control conditions) for social anxiety disorder (median N = 65). 
The final effect size, in correlation coefficient metric, was .32.

\strong{Ego_Depletion} is data from the pre-registered, replication studies for 
the ego-depletion effect (Hagger et al., 2016). These data were from 23 
laboratories (N = 2141).

\strong{Hypomanic_BIS} is data from Katz, Naftalovich, Matanky, and Yovel (2021), who reported 
findings from a meta-analysis of 19 studies on hypomanic personality tendencies 
and behavioral inhibition system sensitivity (median N = 230). The final 
effect size, in correlation coefficient metric, was -.04.

\strong{IAT_Discrimination} is data from a meta-analysis on 298 effect sizes (r values) for the association  
between scores on the Implicit Association Test (IAT) and ethnic and racial discrimination 
(Oswald, Mitchell, Blanton, Jaccard, & Tetlock (2013).

\strong{Many_Labs} is a list with summary data for eight pre-registered datasets described by 
Klein et al. (2014; https://osf.io/wx7ck/).
The datasets were from the Many Labs Replication Project.
For all eight projects, there were attempts to replicate the original effect across 
36 samples (studies), involving over 6,000 participants.
The data are for: (1) Sunk Costs (Oppenheimer, Meyvis, & Davidenko, 2009), 
wherein participants are supposedly more likely to go see their favorite football 
team play an important game on a freezing cold day if they had paid for the ticket 
than if the ticket had been free; (2) Anchoring (Jacowitz & Kahneman, 1995), wherein 
participants subsequent judgments are supposedly affected by anchoring information 
provided by researchers; (3) Gamblers Fallacy (Oppenheimer & Monin, 2009), wherein 
the rarity of an independent, chance observation supposedly influences beliefs about 
what occurred before the event; (4) Quote Attribution (Lorge & Curtiss, 1936), 
wherein participants opinions are supposedly more influenced by whether they are 
exposed to the opinions of a highly regarded than a lowly regarded other person; 
(5) Flag Priming (Carter, Ferguson, & Hassin, 2011; Study 2), wherein subtle 
exposure to the American flag supposedly increases conservative opinions among 
US participants; (6) Currency Priming (Caruso, Vohs, Baxter, & Waytz, 2013), 
wherein mere exposure to money symbols increases participants endorsements of 
the current social system; (7) Imagined Contact (Husnu & Crisp, 2010; Study 1), 
wherein merely imagining contact with members of ethnic outgroups is supposedly 
sufficient to reduce prejudice toward those groups; and (8) Math Attitudes (Nosek, 
Banaji, & Greenwald, 2002), wherein women supposedly have more negative implicit 
attitudes toward math compared to arts than do men.

\strong{Math_Performance} is data from a meta-analysis on 35 effect sizes (r values) for the   
association between individual differences in non-symbolic number acuity and math performance 
(Chen & Li, 2014, Table 1, p. 167).

\strong{Omega3_Depression} is data from a meta-analysis on 12 effect sizes for the role of omega-3 
	fatty acids in the treatment of major depression (Grosso et al., 2014, 
	Figure 2, top portion, p. 9).

\strong{Paired_Samples} is a list with raw data for two variables from 50 random samples,  
	N = 100 each, that were randomly drawn from a population of 100,000 cases in 
	which the difference in mean scores was .50 and the correlation between the two
	variables was .70.

\strong{PopulationR.02} is a list with raw data for two variables from 50 random samples,  
N = 100 each, that were randomly drawn from a population of 100,000 cases in 
which the correlation between the two variables was .02.
The data are from O'Connor and Ermacora (2021).

\strong{PopulationR.10} is a list with raw data for two variables from 50 random samples,  
	N = 100 each, that were randomly drawn from a population of 100,000 cases in 
	which the correlation between the two variables was .10.
The data are from O'Connor and Ermacora (2021).

\strong{PopulationR.11} is a list with raw data for two variables from 50 random samples,  
	N = 36 each, that were randomly drawn from a population of 100,000 cases in 
	which the correlation between the two variables was .11.
The data are from O'Connor and Khattar (2022).

\strong{PopulationR.20} is a list with raw data for two variables from 50 random samples,  
	N = 100 each, that were randomly drawn from a population of 100,000 cases in 
	which the correlation between the two variables was .20.
The data are from O'Connor and Ermacora (2021).

\strong{PopulationR.32} is a list with raw data for two variables from 50 random samples,  
	N = 65 each, that were randomly drawn from a population of 100,000 cases in 
	which the correlation between the two variables was .32.
The data are from O'Connor and Khattar (2022).

\strong{PopulationR.57} is a list with raw data for two variables from 50 random samples,  
	N = 225 each, that were randomly drawn from a population of 100,000 cases in 
	which the correlation between the two variables was .57.
The data are from O'Connor and Khattar (2022).

\strong{PopulationR.077} is a list with raw data for two variables from 50 random samples,  
	N = 50 each, that were randomly drawn from a population of 100,000 cases in 
	which the correlation between the two variables was .077.
The data are from O'Connor and Khattar (2022).

\strong{PopulationRneg.04} is a list with raw data for two variables from 50 random samples,  
	N = 230 each, that were randomly drawn from a population of 100,000 cases in 
	which the correlation between the two variables was -.04.
The data are from O'Connor and Khattar (2022).

\strong{SelfEsteem_Depression} is data from Sowislo and Orth (2013, Table 2), who reported 
findings from a meta-analysis of 
	77 longitudinal studies that provided effect sizes for self-esteem predicting future 
	depressive symptoms (median N = 224). The final effect size, in correlation 
	coefficient metric, was .57.

}

\references{
	{Chen, Q., & Li, J. (2014). Association between individual differences in 
     non-symbolic number acuity and math performance: A meta-analysis. 
   \emph{Acta Psychologica, 148,} 163-172.}  
\cr\cr {Grosso, G., Pajak, A., Marventano, S., Castellano, S., Galvano, F., Bucolo, C., & 
   Caraci, F. (2014). Role of omega-3 fatty acids in the treatment of depressive 
   disorders: A comprehensive meta-analysis of randomized clinical trials. 
   \emph{PLoS ONE, 9(5),} e96905.}   
\cr\cr {Hagger, M. S., Chatzisarantis, N. L., Alberts, H. A., Anggono, C. O., Batailler, C. B., 
   Birt, A. R., et al. (2016). A multilab preregistered replication of the ego-depletion 
   effect. \emph{Perspectives on Psychological Science, 11(4),} 546-573.}   
\cr\cr {Kampmann, I. L., Emmelkamp, P. M. G., & Morina, N. (2016). Meta-analysis of 
	technology-assisted interventions for social anxiety disorder.
	\emph{Journal of Anxiety Disorders, 42,} 7184.}   
\cr\cr {Katz, B. A., Naftalovich, H., Matanky, K., & Yovel, I. (2021). The 
	dual-system theory of bipolar spectrum disorders: A meta-analysis.
	\emph{Clinical Psychology Review, 83,} Article 101945.}   
\cr\cr {Klein, R. A., et al. (2014). Investigating variation in replicability: A many
	labs replication project. \emph{Social Psychology, 45,} 142152.}   
\cr\cr {Large, M., Sharma, S., Compton, M. T., Slade, T., Nielssen, O. (2011). Cannabis 
   use and earlier onset of psychosis: a systematic meta-analysis. 
   \emph{Archives of General Psychiatry, 68(6),} 555-561.}
\cr\cr {O'Connor, B. P., & Ermacora, D. (2021). Unnecessary ping-pong: Illustrations of 
       	why previous findings should be taken into account when evaluating new datasets. 
       	\emph{Canadian Journal of Behavioural Science, 53(3),} 328-341. https://doi.org/10.1037/cbs0000259}   
\cr\cr {O'Connor, B. P., & Khattar, N. (2022). Controversies regarding 
	    null hypothesis testing. In W. O'Donohue, A. Masuda, & S. O. Lilienfeld (Eds.). 
	    \emph{Avoiding Questionable Research Practices in Applied Psychology} (pp. 147-174). 
	    Cham, Switzerland: Springer Nature Switzerland.}
\cr\cr {Oswald, F. L., Mitchell, G., Blanton, H., Jaccard, J., & Tetlock, P. E. (2013). Predicting 
   ethnic and racial discrimination: A meta-analysis of IAT criterion studies. 
   \emph{Journal of Personality and Social Psychology, 105,} 171-192.}   
\cr\cr {Pearl, S. B., & Norton, P. J. (2017). Transdiagnostic versus diagnosis 
   specific cognitive behavioural therapies for anxiety: A meta-analysis. 
   \emph{Journal of Anxiety Disorders, 46,} 11-24.}
\cr\cr {Prestwich, A., Kellar, I., Conner, M., Lawton, R., Gardner, P., & Turgut, L. (2016). 
   Does changing social influence engender changes in alcohol intake? A meta-analysis. 
   \emph{Journal of Consulting & Clinical Psychology, 84,} 845-860.}
\cr\cr {Sowislo, J. F., & Orth, U. (2013). Does low self-esteem predict depression 
   and anxiety? A meta-analysis of longitudinal studies. 
   \emph{Psychological Bulletin, 139(1),} 213240. https://doi.org/10.1037/a0028931}   
\cr\cr {Weston, L., Hodgekins, J., & Langdon, P. E. (2016). Effectiveness of 
   cognitive behavioural therapy with people who have autistic spectrum 
   disorders: A systematic review and meta-analysis. 
   \emph{Clinical Psychology Review, 49,} 4154. 
   https://doi.org/10.1016/j.cpr.2016.08.001}
}

\examples{
names(data_NPP)
\donttest{ 
head(data_NPP$Alcohol_Intake)

head(data_NPP$Anxiety_Therapy)

head(data_NPP$Cannabis_Psychosis)

head(data_NPP$CBT_Autism)

head(data_NPP$CBT_Social_Anxiety)

head(data_NPP$Ego_Depletion)

head(data_NPP$Hypomanic_BIS)

head(data_NPP$IAT_Discrimination)

head(data_NPP$Many_Labs)

head(data_NPP$Math_Performance)

head(data_NPP$Omega3_Depression)

head(data_NPP$Paired_Samples)

head(data_NPP$PopulationR.02)

head(data_NPP$PopulationR.10)

head(data_NPP$PopulationR.11)

head(data_NPP$PopulationR.20)

head(data_NPP$PopulationR.32)

head(data_NPP$PopulationR.57)

head(data_NPP$PopulationR.077)

head(data_NPP$PopulationRneg.04)

head(data_NPP$SelfEsteem_Depression)
}
}
