% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNMoMoData.R
\name{NNMoMoData}
\alias{NNMoMoData}
\title{Create NNMoMoData Object from Demogdata Object or HMD Datasets}
\usage{
NNMoMoData(...)
}
\arguments{
\item{...}{One or more objects of class \code{demogdata}. Each input must
contain mortality rates and population data for both sexes
("female", "male"), structured as in the \pkg{demography} package. If no
arguments are provided, the function will prompt the user for Human Mortality
Database (HMD) login credentials (email and password) and automatically
download a predefined list of countries using
\code{\link[demography]{hmd.mx}}. The list of countries is the same used by
Scognamiglio, S. (2022). Calibrating the Lee-Carter and the Poisson
Lee-Carter models via neural networks. ASTIN Bulletin: The Journal of the
IAA, 52(2), 519-561. Cambridge University Press. \doi{10.1017/asb.2022.5}}
}
\value{
An object of class \code{NNMoMoData} containing the following
columns:
\itemize{
\item \code{country}: Country label from the input \code{demogdata}
object.
\item \code{sex}: Sex of the population ("female" or "male").
\item \code{year}: Calendar year.
\item \code{rate_*}: Mortality rates by age (e.g., \code{rate_0},
\code{rate_1}, ...).
\item \code{pop_*}: Population counts by age (e.g., \code{pop_0},
\code{pop_1}, ...).
}
}
\description{
Utility function to construct an object of class \code{NNMoMoData} from one
or multiple mortality datasets of class \code{demogdata}. Each dataset is
converted into a tabular representation with mortality rates and population
counts by age, sex, and year, suitable for fitting a neural network using
\code{\link{fit.NNMoMo}}.
}
\details{
This function converts the age-by-year matrices of mortality rates and
populations into long-format rows, one row per sex-year combination. Each
row stores the full vector of rates and populations across all ages.

If any input is not of class \code{demogdata}, the function stops with an
error.

If no inputs are provided, the function connects to the Human Mortality
Database (HMD) using user-supplied credentials and downloads a predefined
set of countries (AUS, AUT, BEL, BGR, BLR, CAN, CHE, CZE, DEUTE, DEUTW,
DNK, ESP, EST, FIN, FRATNP, GBRTENW, GBR_NIR, GBR_SCO, GRC, HUN, IRL, ISL,
ISR, ITA, JPN, LTU, LUX, LVA, NLD, NOR, NZL_NM, POL, PRT, RUS, SVK, SVN,
SWE, TWN, UKR, USA). It might take a few minutes to download all of them.

A \code{demogdata} object can also be created from scratch or imported
manually from the Human Mortality Database using
\code{\link[demography]{hmd.mx}}.

The label of the \code{demogdata} object must be specified,
as all subsequent operations rely on this label.
}
\examples{
# Example 1: Create from an existing demogdata object
demography_obj <- demography::demogdata(
  data = matrix(runif(10*5), nrow = 10),
  pop = matrix(runif(10*5, 1000, 2000), nrow = 10),
  ages = 50:59,
  years = 2000:2004,
  type = "mortality",
  name = "male",
  label = "France"
)
nn_data <- NNMoMoData(demography_obj)
head(nn_data)

\dontrun{
# Example 2: Automatic download from HMD if no arguments are provided
# (will prompt for email and password, requires HMD access)
nn_data_auto <- NNMoMoData()
head(nn_data_auto)
}
}
