% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multigreyforecast.R
\name{multigreyforecast}
\alias{multigreyforecast}
\title{Forecast the GM (1, 1) model for multivariate time series data}
\usage{
multigreyforecast(data, h)
}
\arguments{
\item{data}{Input multivariate time series data.}

\item{h}{The forecast horizon.}
}
\value{
A h-step ahead forecast values
\item{forecast}{h-step ahead forecast values corresponding to each of the variables in the multivariate time series data.}
}
\description{
The multigreyforecast function computes the h-step ahead forecast values for each of the variables in the multivariate time series data.
}
\details{
This function returns the h-step ahead forecasted values of the fitted GM (1, 1) model for each of the variables
         in the multivariate time series data.
}
\examples{
# Example data
xt <- c(640, 684, 713, 745, 809, 811, 883, 893, 904, 935, 1044, 1069)
yt <- c(50, 64, 93, 113, 131, 152, 164, 201, 224, 268, 286, 290)
zt  <- c(550,504,493,413,431,352,364,301,294,268,286,230)
data <- cbind(xt, yt, zt)

# Apply the multigreyfit function
multigreyforecast(data, h=3)
}
\references{
Akay, D. and Atak, M. (2007). Grey prediction with rolling mechanism for electricity demand forecasting of Turkey.
\emph{Energy}, 32(9), 1670-1675.<DOI:10.1016/j.energy.2006.11.014>

Deng, J. (1989). Introduction to grey system theory. \emph{The Journal of Grey System}, 1(1), 1-24.

Hsu, L.C. and Wang, C.H. (2007). Forecasting the output of integrated circuit industry using a grey model improved by
Bayesian analysis. \emph{Technological Forecasting and Social Change}, 74(6), 843-853.<DOI:10.1016/j.techfore.2006.02.005>
}
