% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.mplustree.R
\name{summary.mplustree}
\alias{summary.mplustree}
\title{Summarizing MplusTrees model Fits}
\usage{
\method{summary}{mplustree}(object, ...)
}
\arguments{
\item{object}{An object of class "mplustree" (a fitted Mplus Tree)}

\item{...}{Other arguments passed to or from other methods}
}
\description{
\code{summary} method for class "mplustree".
}
\details{
Prints the tree structure given in \code{object}
}
\examples{
\dontrun{
library(lavaan)

script = mplusObject(
   TITLE = "Example #1 - Factor Model;",
   MODEL = "f1 BY x1-x3; f2 BY x4-x6; f3 BY x7-x9;",
   usevariables = c('x1','x2','x3','x4','x5','x6','x7','x8','x9'),
   rdata = HolzingerSwineford1939)

fit = MplusTrees(script, HolzingerSwineford1939, group=~id,
   rPartFormula=~sex+school+grade, control=rpart.control(cp=.01))

summary(fit)
}
}
