% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_results}
\alias{plot_results}
\title{Plot posterior mixture density from MCMC samples}
\usage{
plot_results(
  M2_w1,
  M2_alpha1,
  M2_beta1,
  M2_delta1,
  M2_omega1,
  M2_w2,
  M2_alpha2,
  M2_beta2,
  M2_delta2,
  M2_omega2,
  xx,
  xx_true = NULL,
  yy_true = NULL
)
}
\arguments{
\item{M2_w1}{Numeric scalar. Mixture weight of first component.}

\item{M2_alpha1}{Numeric vector. Stability parameter samples of first component.}

\item{M2_beta1}{Numeric vector. Skewness parameter samples of first component.}

\item{M2_delta1}{Numeric vector. Location parameter samples of first component.}

\item{M2_omega1}{Numeric vector. Scale parameter samples of first component.}

\item{M2_w2}{Numeric scalar. Mixture weight of second component.}

\item{M2_alpha2}{Numeric vector. Stability parameter samples of second component.}

\item{M2_beta2}{Numeric vector. Skewness parameter samples of second component.}

\item{M2_delta2}{Numeric vector. Location parameter samples of second component.}

\item{M2_omega2}{Numeric vector. Scale parameter samples of second component.}

\item{xx}{Numeric vector of grid values for density evaluation.}

\item{xx_true}{Optional numeric vector for true density x-values.}

\item{yy_true}{Optional numeric vector for true density y-values.}
}
\value{
Invisibly returns the file path to the saved PNG image of the posterior mixture density plot.
}
\description{
Visualizes the estimated two-component alpha-stable mixture density
using parameters obtained from MCMC sampling. Optionally overlays
the true density for comparison.
}
